/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.action.menu;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.extension.client.Activator;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuModifier;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuContributionExtension;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuExtensionManager;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuModificationExtension;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuRemoveExtension;
import org.eclipse.scout.rt.extension.client.ui.desktop.internal.OrderedMenuWrapper;

public final class MenuExtensionUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MenuExtensionUtility.class);

    private MenuExtensionUtility() {
    }

    public static <T> Class<T> getAnchorType(T anchor) {
        if (anchor == null) {
            return null;
        }
        if (anchor instanceof IPage) {
            return IPage.class;
        }
        if (anchor instanceof IFormField) {
            return IFormField.class;
        }
        if (anchor instanceof IMenu) {
            return IMenu.class;
        }
        if (anchor instanceof ITreeNode) {
            return ITreeNode.class;
        }
        if (anchor instanceof IDesktop) {
            return IDesktop.class;
        }
        return null;
    }

    public static <T> void adaptMenus(T anchor, Object container, List<IMenu> menuList) {
        MenuExtensionUtility.adaptMenus(anchor, container, menuList, false);
    }

    public static <T> void adaptMenus(T anchor, Object container, List<IMenu> menuList, boolean createOrderedMenuWrapper) {
        Class<T> anchorType = MenuExtensionUtility.getAnchorType(anchor);
        if (anchorType == null || anchor == null || container == null) {
            return;
        }
        MenuExtensionManager extensionManager = Activator.getDefault().getMenuExtensionManager();
        MenuExtensionUtility.contributeMenus(anchor, container, extensionManager.getMenuContributionExtensions(anchorType), menuList, createOrderedMenuWrapper);
        MenuExtensionUtility.removeMenus(anchor, container, extensionManager.getMenuRemoveExtensions(anchorType), menuList);
        MenuExtensionUtility.modifyMenus(anchor, container, extensionManager.getMenuModificationExtensions(anchorType), menuList);
    }

    static <T> void contributeMenus(T anchor, Object container, List<MenuContributionExtension> extensions, List<IMenu> menuList, boolean createOrderedMenuWrapper) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        LinkedList<MenuContributionExtension> matchingExtensions = new LinkedList<MenuContributionExtension>();
        for (MenuContributionExtension e : extensions) {
            if (!e.accept(anchor, container, null)) continue;
            matchingExtensions.add(e);
        }
        if (matchingExtensions.isEmpty()) {
            return;
        }
        TreeMap<CompositeObject, IMenu> orderedMenus = new TreeMap<CompositeObject, IMenu>();
        int counter = 0;
        for (IMenu m : menuList) {
            Order orderAnnotation;
            Class<?> tmpClass = m.getClass();
            while ((orderAnnotation = tmpClass.getAnnotation(Order.class)) == null && m.getClass().isAnnotationPresent(Replace.class)) {
                tmpClass = tmpClass.getSuperclass();
            }
            double order = orderAnnotation != null ? orderAnnotation.value() : Double.MAX_VALUE;
            orderedMenus.put(new CompositeObject(new Object[]{order, counter}), m);
            ++counter;
        }
        for (MenuContributionExtension e : matchingExtensions) {
            try {
                IMenu m = e.createContribution(anchor, container);
                if (createOrderedMenuWrapper) {
                    m = new OrderedMenuWrapper(m, e.getOrder());
                }
                orderedMenus.put(new CompositeObject(new Object[]{e.getOrder(), counter}), m);
                ++counter;
            }
            catch (Throwable t) {
                LOG.error("Exception while creating an instance of contributed menu " + e, t);
            }
        }
        menuList.clear();
        menuList.addAll(orderedMenus.values());
    }

    static <T> void removeMenus(T anchor, Object container, List<MenuRemoveExtension> extensions, List<IMenu> menuList) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        Iterator<IMenu> it = menuList.iterator();
        block0: while (it.hasNext()) {
            IMenu next = it.next();
            for (MenuRemoveExtension removeExtension : extensions) {
                if (!removeExtension.accept(anchor, container, next)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    static <T> void modifyMenus(T anchor, Object container, List<MenuModificationExtension> extensions, List<IMenu> menuList) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        for (MenuModificationExtension ext : extensions) {
            for (IMenu menu : menuList) {
                try {
                    if (!ext.accept(anchor, container, menu)) continue;
                    IMenuModifier<IMenu> menuModifier = ext.createMenuModifier();
                    menuModifier.modify(anchor, container, menu);
                }
                catch (ProcessingException e) {
                    LOG.error("Exception while modifying menu", (Throwable)e);
                }
            }
        }
    }
}

