/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.lang.reflect.Method;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.ITableBeanHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class TableBeanHolderOutput
implements IBindOutput {
    private ITableBeanHolder m_holder;
    private Method m_getterMethod;
    private Method m_setterMethod;
    private Class m_beanType;
    private ValueOutputToken m_source;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;

    public TableBeanHolderOutput(ITableBeanHolder holder, String columnName, ValueOutputToken source) throws ProcessingException {
        this.m_holder = holder;
        try {
            this.m_getterMethod = this.m_holder.getRowType().getMethod("get" + Character.toUpperCase(columnName.charAt(0)) + columnName.substring(1), new Class[0]);
            this.m_beanType = this.m_getterMethod.getReturnType();
            this.m_setterMethod = this.m_holder.getRowType().getMethod("set" + Character.toUpperCase(columnName.charAt(0)) + columnName.substring(1), this.m_beanType);
        }
        catch (Throwable e) {
            throw new ProcessingException("unexpected exception", e);
        }
        this.m_source = source;
    }

    @Override
    public IToken getToken() {
        return this.m_source;
    }

    @Override
    public boolean isJdbcBind() {
        return !this.m_source.isSelectInto();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public boolean isSelectInto() {
        return this.m_source.isSelectInto();
    }

    @Override
    public Class getBindType() {
        return this.m_getterMethod.getReturnType();
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public void finishBatch() {
        TableBeanHolderOutput.ensureSize(this.m_holder, this.m_batchIndex + 1);
    }

    @Override
    public void setReplaceToken(ISqlStyle style) {
        this.m_source.setReplaceToken("?");
    }

    @Override
    public void consumeValue(Object value) throws ProcessingException {
        TableBeanHolderOutput.ensureSize(this.m_holder, this.m_batchIndex + 1);
        try {
            Object castValue = TypeCastUtility.castValue((Object)value, (Class)this.m_beanType);
            this.m_setterMethod.invoke((Object)this.m_holder.getRows()[this.m_batchIndex], castValue);
        }
        catch (Throwable e) {
            throw new ProcessingException("unexpected exception", e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[bindType=" + this.getBindType() + ", source=" + this.m_source + "]";
    }

    private static void ensureSize(ITableBeanHolder table, int size) {
        while (table.getRowCount() < size) {
            table.addRow();
        }
        while (table.getRowCount() > size) {
            table.removeRow(table.getRowCount() - 1);
        }
    }
}

