/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.offline;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.services.common.offline.IOfflineDispatcherService;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.service.ServiceUtility;

public class OfflineDispatcherService
extends AbstractService
implements IOfflineDispatcherService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(OfflineDispatcherService.class);
    private Class<? extends IServerSession> m_serverSessionClass;
    private IServerSession m_serverSession;
    private Subject m_subject;
    private final Thread m_dispatcherThread;
    private final Object m_queueLock;
    private final LinkedList<Runnable> m_queue = new LinkedList();

    public OfflineDispatcherService() {
        this.m_queueLock = new Object();
        this.m_dispatcherThread = new Thread("Dispatcher for " + ((Object)((Object)this)).getClass().getName()){

            @Override
            public void run() {
                OfflineState.setOfflineInCurrentThread((Boolean)true);
                while (true) {
                    try {
                        while (true) {
                            OfflineDispatcherService.this.dispatchNextJob();
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Error while executing job in offline dispatcher thread.", t);
                        continue;
                    }
                    break;
                }
            }
        };
        this.m_dispatcherThread.setDaemon(true);
        this.m_dispatcherThread.start();
    }

    public String getServerSessionClass() {
        return this.m_serverSessionClass != null ? this.m_serverSessionClass.getName() : null;
    }

    public void setServerSessionClass(String className) {
        int i = className.lastIndexOf(46);
        try {
            this.m_serverSessionClass = Platform.getBundle((String)className.substring(0, i)).loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Loading class " + className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceTunnelResponse dispatch(final IServiceTunnelRequest request, IProgressMonitor monitor) {
        Thread currentThread;
        final Subject subject = Subject.getSubject(AccessController.getContext());
        if (this.m_serverSessionClass == null) {
            String className = Platform.getProduct().getDefiningBundle().getSymbolicName();
            className = String.valueOf(className.replaceAll("\\.ui\\..*$", ".server.core")) + ".ServerSession";
            int i = className.lastIndexOf(46);
            try {
                LOG.warn("missing config.ini property: " + ((Object)((Object)this)).getClass().getName() + "#serverSessionClass=your.app.server.ServerSession. Trying to find default class " + className);
                this.m_serverSessionClass = Platform.getBundle((String)className.substring(0, i)).loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (this.m_serverSessionClass == null) {
                return new ServiceTunnelResponse(null, null, (Throwable)new ProcessingException("missing config.ini property: " + ((Object)((Object)this)).getClass().getName() + "#serverSessionClass=your.app.server.ServerSession"));
            }
        }
        if ((currentThread = Thread.currentThread()) == this.m_dispatcherThread) {
            try {
                return this.callService(request);
            }
            catch (Throwable e) {
                return new ServiceTunnelResponse(null, null, e);
            }
        }
        final Object waitLock = new Object();
        final Holder responseHolder = new Holder(ServiceTunnelResponse.class);
        if (!(currentThread.isInterrupted() || monitor != null && monitor.isCanceled())) {
            Runnable job = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServiceTunnelResponse res = OfflineDispatcherService.this.dispatchInServerThread(request, subject);
                        responseHolder.setValue((Object)res);
                    }
                    catch (Throwable throwable) {
                        Object object = waitLock;
                        synchronized (object) {
                            waitLock.notifyAll();
                        }
                        throw throwable;
                    }
                    Object object = waitLock;
                    synchronized (object) {
                        waitLock.notifyAll();
                    }
                }
            };
            this.enqueueJob(job);
            Object object = waitLock;
            synchronized (object) {
                while (!(responseHolder.getValue() != null || currentThread.isInterrupted() || monitor != null && monitor.isCanceled())) {
                    try {
                        waitLock.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        responseHolder.setValue((Object)new ServiceTunnelResponse(null, null, (Throwable)e));
                    }
                }
            }
        }
        if (responseHolder.getValue() == null) return new ServiceTunnelResponse(null, null, (Throwable)new InterruptedException("Result from handler was null"));
        return (ServiceTunnelResponse)responseHolder.getValue();
    }

    private ServiceTunnelResponse dispatchInServerThread(IServiceTunnelRequest request, Subject subject) {
        Map<Class, Object> backup = ThreadContext.backup();
        try {
            Holder responseHolder;
            ServerJob job;
            IStatus status;
            if (this.m_serverSession == null || subject == null || !subject.equals(this.m_subject)) {
                try {
                    this.m_subject = subject;
                    UserAgent userAgent = UserAgent.createByIdentifier((String)request.getUserAgent());
                    this.m_serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(this.m_serverSessionClass, subject, userAgent);
                }
                catch (ProcessingException e) {
                    ServiceTunnelResponse serviceTunnelResponse = new ServiceTunnelResponse(null, null, (Throwable)e);
                    ThreadContext.restore(backup);
                    return serviceTunnelResponse;
                }
            }
            if (!(status = (job = new ServerJob("Offline invokation", this.m_serverSession, subject, responseHolder = new Holder(ServiceTunnelResponse.class), request){
                private final /* synthetic */ Holder val$responseHolder;
                private final /* synthetic */ IServiceTunnelRequest val$request;
                {
                    this.val$responseHolder = holder;
                    this.val$request = iServiceTunnelRequest;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                @Override
                protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                    this.val$responseHolder.setValue((Object)OfflineDispatcherService.this.callService(this.val$request));
                    return Status.OK_STATUS;
                }
            }).runNow((IProgressMonitor)new NullProgressMonitor())).isOK()) {
                ServiceTunnelResponse serviceTunnelResponse = new ServiceTunnelResponse(null, null, (Throwable)new ProcessingException(status));
                return serviceTunnelResponse;
            }
            ServiceTunnelResponse serviceTunnelResponse = (ServiceTunnelResponse)responseHolder.getValue();
            return serviceTunnelResponse;
        }
        finally {
            ThreadContext.restore(backup);
        }
    }

    private ServiceTunnelResponse callService(IServiceTunnelRequest serviceReq) throws Exception {
        try {
            IServerSession serverSession = ThreadContext.getServerSession();
            Class serviceInterfaceClass = serverSession.getBundle().loadClass(serviceReq.getServiceInterfaceClassName());
            Object service = SERVICES.getService((Class)serviceInterfaceClass);
            if (service == null) {
                throw new ProcessingException("service registry does not contain a service of type " + serviceReq.getServiceInterfaceClassName());
            }
            Method serviceOp = ServiceUtility.getServiceOperation((Class)serviceInterfaceClass, (String)serviceReq.getOperation(), (Class[])serviceReq.getParameterTypes());
            Object data = ServiceUtility.invoke((Method)serviceOp, (Object)service, (Object[])serviceReq.getArgs());
            Object[] outParameters = ServiceUtility.extractHolderArguments((Object[])serviceReq.getArgs());
            ServiceTunnelResponse serviceRes = new ServiceTunnelResponse(data, outParameters, null);
            serviceRes.setClientNotifications(((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).getNextNotifications(0L));
            return serviceRes;
        }
        catch (Throwable t) {
            ITransaction transaction = ThreadContext.getTransaction();
            if (transaction != null) {
                transaction.addFailure(t);
            }
            return new ServiceTunnelResponse(null, null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueJob(Runnable r) {
        Object object = this.m_queueLock;
        synchronized (object) {
            this.m_queue.add(r);
            this.m_queueLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchNextJob() throws InterruptedException {
        Object object = this.m_queueLock;
        synchronized (object) {
            if (this.m_queue.isEmpty()) {
                this.m_queueLock.wait();
            }
            if (!this.m_queue.isEmpty()) {
                Runnable r = this.m_queue.remove(0);
                r.run();
            }
        }
    }
}

