/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form.fields.treefield;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;

public class TreeNodeData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private TreeNodeData m_parentNode;
    private List<TreeNodeData> m_childNodes = new ArrayList<TreeNodeData>(2);
    private List<? extends Object> m_values;
    private List<String> m_texts;

    public Object clone() {
        try {
            TreeNodeData copy = (TreeNodeData)super.clone();
            if (this.m_childNodes != null) {
                copy.m_childNodes = new ArrayList<TreeNodeData>(this.m_childNodes.size());
                for (TreeNodeData n : this.m_childNodes) {
                    copy.m_childNodes.add((TreeNodeData)n.clone());
                }
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public TreeNodeData getParentNode() {
        return this.m_parentNode;
    }

    public void setParentNode(TreeNodeData parentNode) {
        this.m_parentNode = parentNode;
    }

    public List<TreeNodeData> getChildNodes() {
        return this.m_childNodes;
    }

    public void setChildNodes(List<TreeNodeData> childNodes) {
        this.m_childNodes = childNodes;
        if (this.m_childNodes != null) {
            for (TreeNodeData n : this.m_childNodes) {
                n.setParentNode(this);
            }
        }
    }

    public List<Object> getValues() {
        return CollectionUtility.arrayList(this.m_values);
    }

    public void setValues(List<? extends Object> a) {
        this.m_values = CollectionUtility.arrayList(a);
    }

    public List<String> getTexts() {
        return CollectionUtility.arrayList(this.m_texts);
    }

    public void setTexts(List<String> a) {
        this.m_texts = CollectionUtility.arrayList(a);
    }
}

