/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.busy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BusyBlockDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private static final String DIALOG_VARIANT = "busy-dialog";
    private IRwtEnvironment m_uiEnvironment;
    private IProgressMonitor m_progressMonitor;
    private Label m_messageLabel;

    public BusyBlockDialog(Shell parentShell, IRwtEnvironment uiEnvironment, IProgressMonitor progressMonitor) {
        super(parentShell);
        this.m_uiEnvironment = uiEnvironment;
        this.m_progressMonitor = progressMonitor;
        this.setShellStyle(65536);
        this.setBlockOnOpen(false);
    }

    protected String getDialogVariant() {
        return DIALOG_VARIANT;
    }

    public void create() {
        super.create();
        this.getShell().setData("extendedStyle", (Object)8);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        GridLayout dialogAreaLayout = RwtLayoutUtility.createGridLayoutNoSpacing((int)1, (boolean)false);
        dialogAreaLayout.marginTop = 12;
        dialogAreaLayout.marginBottom = 8;
        dialogAreaLayout.marginWidth = 12;
        container.setLayout((Layout)dialogAreaLayout);
        this.m_messageLabel = this.getUiEnvironment().getFormToolkit().createLabel(container, RwtUtility.getNlsText((Display)Display.getCurrent(), (String)"MobileBusyBlockingMessage", (String[])new String[0]), 0x1000040);
        GridData gridData = new GridData(4, 4, true, true);
        this.m_messageLabel.setLayoutData((Object)gridData);
        this.m_messageLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonArea = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        buttonArea.setLayoutData((Object)new GridData(768));
        GridLayout layout = RwtLayoutUtility.createGridLayoutNoSpacing((int)1, (boolean)false);
        layout.marginHeight = 8;
        buttonArea.setLayout((Layout)layout);
        Button cancelButton = this.createButton(buttonArea, RwtUtility.getNlsText((Display)Display.getCurrent(), (String)"MobileBusyBlockingAbort", (String[])new String[0]), null);
        cancelButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        return buttonArea;
    }

    protected Button createButton(Composite parent, String text, String iconId) {
        Button b = this.getUiEnvironment().getFormToolkit().createButton(parent, text, 8);
        if (iconId != null) {
            b.setImage(this.getUiEnvironment().getIcon(iconId));
        }
        b.addSelectionListener((SelectionListener)new P_RwtButtonListener());
        return b;
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    private void handleUiButtonSelection() {
        this.m_progressMonitor.setCanceled(true);
    }

    private class P_RwtButtonListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        public void widgetSelected(SelectionEvent e) {
            BusyBlockDialog.this.handleUiButtonSelection();
        }
    }
}

