/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.datefield;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.IRwtScoutTimeField;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser.TimeChooserDialog;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.datefield.chooser.MobileTimeChooserDialog;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RwtScoutMobileTimeField
extends RwtScoutValueFieldComposite<IDateField>
implements IRwtScoutTimeField {
    private final String VARIANT_TIMEFIELD_ICON = "timefield_icon";
    private final String VARIANT_TIMEFIELD_ICON_DISABLED = "timefield_icon-disabled";
    private boolean m_ignoreLabel = false;
    private Composite m_timeContainer;
    private Composite m_iconContainer;
    private boolean m_dateTimeCompositeMember;
    private TimeChooserDialog m_timeChooserDialog = null;

    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_timeContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 2048);
        this.m_timeContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield");
        Text textField = new Text(this.m_timeContainer, 0);
        this.getUiEnvironment().getFormToolkit().adapt((Control)textField, false, false);
        textField.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield");
        this.m_iconContainer = this.getUiEnvironment().getFormToolkit().createComposite(this.m_timeContainer, 0);
        this.m_iconContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield_icon");
        this.setUiContainer(container);
        this.setUiLabel((ILabelComposite)label);
        this.setUiField((Control)textField);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_timeContainer.setLayoutData((Object)LogicalGridDataBuilder.createField((org.eclipse.scout.rt.client.ui.form.fields.GridData)((IFormField)this.getScoutObject()).getGridData()));
        GridLayout gridLayout = RwtLayoutUtility.createGridLayoutNoSpacing((int)2, (boolean)false);
        gridLayout.marginLeft = 6;
        gridLayout.marginRight = 6;
        this.m_timeContainer.setLayout((Layout)gridLayout);
        GridData textLayoutData = new GridData(4, 0x1000000, true, true);
        textField.setLayoutData((Object)textLayoutData);
        GridData buttonLayoutData = new GridData(0x1000000, 0x1000000, false, false);
        buttonLayoutData.heightHint = 20;
        buttonLayoutData.widthHint = 20;
        this.m_iconContainer.setLayoutData((Object)buttonLayoutData);
        textField.addMouseListener((MouseListener)new P_FieldSelectionListener());
        this.m_iconContainer.addMouseListener((MouseListener)new P_FieldSelectionListener());
        this.m_timeContainer.addMouseListener((MouseListener)new P_FieldSelectionListener());
    }

    public Button getDropDownButton() {
        return null;
    }

    public Text getUiField() {
        return (Text)super.getUiField();
    }

    public void setIgnoreLabel(boolean ignoreLabel) {
        this.m_ignoreLabel = ignoreLabel;
        if (ignoreLabel) {
            this.getUiLabel().setVisible(false);
        } else {
            this.getUiLabel().setVisible(((IDateField)this.getScoutObject()).isLabelVisible());
        }
    }

    public boolean isIgnoreLabel() {
        return this.m_ignoreLabel;
    }

    public boolean isDateTimeCompositeMember() {
        return this.m_dateTimeCompositeMember;
    }

    public void setDateTimeCompositeMember(boolean dateTimeCompositeMember) {
        this.m_dateTimeCompositeMember = dateTimeCompositeMember;
    }

    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.getUiField().setEnabled(true);
        this.getUiField().setEditable(false);
        if (b) {
            this.m_timeContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield");
            this.m_iconContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield_icon");
        } else {
            this.m_timeContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield-disabled");
            this.m_iconContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield_icon-disabled");
        }
    }

    protected void setFieldEnabled(Control field, boolean enabled) {
    }

    protected void setLabelVisibleFromScout() {
        if (!this.isIgnoreLabel()) {
            super.setLabelVisibleFromScout();
        }
    }

    protected void setDisplayTextFromScout(String s) {
        DateFormat format;
        Date value;
        IDateField scoutField = (IDateField)this.getScoutObject();
        if (s == null) {
            s = "";
        }
        if ((value = (Date)scoutField.getValue()) != null && (format = scoutField.getIsolatedTimeFormat()) != null) {
            s = format.format(value);
        }
        this.getUiField().setText(s);
    }

    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, (Control)this.m_timeContainer);
    }

    protected void makeSureTimeChooserIsClosed() {
        if (this.m_timeChooserDialog != null && this.m_timeChooserDialog.getShell() != null && !this.m_timeChooserDialog.getShell().isDisposed()) {
            this.m_timeChooserDialog.getShell().close();
        }
    }

    private void handleUiTimeChooserAction() {
        Date oldTime = (Date)((IDateField)this.getScoutObject()).getValue();
        if (oldTime == null) {
            oldTime = new Date();
        }
        this.makeSureTimeChooserIsClosed();
        this.m_timeChooserDialog = this.createTimeChooserDialog(oldTime);
        if (this.m_timeChooserDialog != null) {
            this.m_timeChooserDialog.getShell().addDisposeListener(new DisposeListener(){
                private static final long serialVersionUID = 1L;

                public void widgetDisposed(DisposeEvent event) {
                    RwtScoutMobileTimeField.this.m_timeChooserDialog.getShell().removeDisposeListener((DisposeListener)this);
                    RwtScoutMobileTimeField.this.getTimeFromClosedDateChooserDialog();
                }
            });
            this.m_timeChooserDialog.open();
        }
    }

    protected MobileTimeChooserDialog createTimeChooserDialog(Date currentTime) {
        return new MobileTimeChooserDialog(this.getUiField().getShell(), (Control)this.getUiField(), currentTime);
    }

    private void getTimeFromClosedDateChooserDialog() {
        final Date newDate = this.m_timeChooserDialog.getReturnTime();
        if (newDate != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IDateField)RwtScoutMobileTimeField.this.getScoutObject()).getUIFacade().setTimeFromUI(newDate);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_FieldSelectionListener
    extends MouseAdapter {
        private static final long serialVersionUID = 1L;

        private P_FieldSelectionListener() {
        }

        public void mouseUp(MouseEvent e) {
            if (!((IDateField)RwtScoutMobileTimeField.this.getScoutObject()).isEnabled()) {
                return;
            }
            RwtScoutMobileTimeField.this.handleUiTimeChooserAction();
        }
    }
}

