/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import java.util.HashMap;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IProposalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class RwtScoutColumnModel
extends ColumnLabelProvider {
    private static final long serialVersionUID = 1L;
    private static final int HTML_ROW_LINE_HIGHT = 19;
    private static final int NEWLINE_LINE_HIGHT = 15;
    private transient ListenerList listenerList = null;
    private final ITable m_scoutTable;
    private HashMap<ITableRow, HashMap<IColumn<?>, ICell>> m_cachedCells;
    private final RwtScoutTable m_uiTable;
    private final TableColumnManager m_columnManager;
    private Image m_imgCheckboxFalse;
    private Image m_imgCheckboxTrue;
    private Color m_disabledForegroundColor;
    private int m_defaultRowHeight;
    private final IRwtEnvironment m_env;

    public RwtScoutColumnModel(ITable scoutTable, RwtScoutTable uiTable, TableColumnManager columnManager) {
        this.m_scoutTable = scoutTable;
        this.m_uiTable = uiTable;
        this.m_columnManager = columnManager;
        this.m_env = this.getUiTable().getUiEnvironment();
        this.m_imgCheckboxTrue = this.m_env.getIcon("checkbox_yes");
        this.m_imgCheckboxFalse = this.m_env.getIcon("checkbox_no");
        this.m_disabledForegroundColor = this.m_env.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
        this.rebuildCache();
    }

    protected ITable getScoutTable() {
        return this.m_scoutTable;
    }

    public RwtScoutTable getUiTable() {
        return this.m_uiTable;
    }

    public void update(ViewerCell cell) {
        ITableRow element = (ITableRow)cell.getElement();
        int columnIndex = cell.getColumnIndex();
        cell.setText(this.getColumnText(element, columnIndex));
        cell.setImage(this.getColumnImage(element, columnIndex));
        cell.setBackground(this.getBackground(element, columnIndex));
        cell.setForeground(this.getForeground(element, columnIndex));
        cell.setFont(this.getFont(element, columnIndex));
    }

    public String getColumnText(ITableRow element, int columnIndex) {
        ICell cell = this.getCell(element, columnIndex);
        if (cell == null) {
            return "";
        }
        String text = cell.getText();
        if (text == null) {
            text = "";
        } else if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
            text = this.m_env.adaptHtmlCell(this.getUiTable(), text);
            text = this.m_env.convertLinksInHtmlCell(this.getUiTable(), text);
        } else {
            boolean multiline = this.isMultiline(text);
            if (!multiline) {
                text = this.replaceLineBreaksInMultilineText(text);
            }
            if (cell.isHtmlEnabled() && (RwtUtility.isMarkupEnabled((Widget)this.getUiTable().getUiField()) || multiline)) {
                boolean replaceBreakableChars = true;
                IColumn<?> column = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
                if (column instanceof IStringColumn && this.getScoutTable().isMultilineText()) {
                    IStringColumn stringColumn = (IStringColumn)column;
                    replaceBreakableChars = !stringColumn.isTextWrap();
                }
                return HtmlTextUtility.transformPlainTextToHtml(text, replaceBreakableChars);
            }
        }
        return HtmlTextUtility.validateHtmlCapableText(this.m_env.getHtmlValidator(), cell, text);
    }

    private boolean isMultiline(String text) {
        return this.isMultilineText(text) && this.getScoutTable().isMultilineText();
    }

    private boolean isMultilineText(String text) {
        return text.indexOf("\n") >= 0;
    }

    private String replaceLineBreaksInMultilineText(String text) {
        if (this.isMultilineText(text)) {
            text = StringUtility.replaceNewLines((String)text, (String)" ");
        }
        return text;
    }

    protected int getDefaultRowHeight() {
        return this.m_defaultRowHeight;
    }

    public Image getColumnImage(ITableRow element, int columnIndex) {
        int[] columnOrder = this.getUiTable().getUiField().getColumnOrder();
        if (columnOrder.length <= 1) {
            return null;
        }
        IColumn<?> col = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
        ICell cell = this.getCell(element, columnIndex);
        Image checkBoxImage = null;
        if (columnOrder[1] == columnIndex && this.getUiTable().getScoutObject() != null && ((ITable)this.getUiTable().getScoutObject()).isCheckable()) {
            checkBoxImage = element.isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        } else if (!(col == null || cell == null || col.getDataType() != Boolean.class || col instanceof IProposalColumn && ((IProposalColumn)col).getLookupCall() != null)) {
            Boolean b = (Boolean)cell.getValue();
            checkBoxImage = b != null && b != false ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        }
        String iconId = null;
        if (cell != null && cell.getErrorStatus() != null && cell.getErrorStatus().getSeverity() == 4) {
            iconId = "status_error";
        } else if (cell != null && cell.getIconId() != null) {
            iconId = cell.getIconId();
        } else if (columnOrder[1] == columnIndex) {
            iconId = element.getIconId();
        }
        Image decoImage = this.m_env.getIcon(iconId);
        if (checkBoxImage != null && decoImage != null) {
            return checkBoxImage;
        }
        if (checkBoxImage != null) {
            return checkBoxImage;
        }
        if (decoImage != null) {
            return decoImage;
        }
        return null;
    }

    public Color getBackground(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_env.getColor(cell.getBackgroundColor());
        }
        return null;
    }

    public Color getForeground(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            Color col = this.m_env.getColor(cell.getForegroundColor());
            if (!(col != null || element.isEnabled() && cell.isEnabled())) {
                col = this.m_disabledForegroundColor;
            }
            return col;
        }
        return null;
    }

    public Font getFont(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_env.getFont(cell.getFont(), this.getUiTable().getUiField().getFont());
        }
        return null;
    }

    public String getToolTipText(Object element) {
        Display display = this.m_env.getDisplay();
        Point cursorOnTable = display.map(null, (Control)this.getUiTable().getUiField(), display.getCursorLocation());
        ViewerCell uiCell = this.getUiTable().getUiTableViewer().getCell(cursorOnTable);
        String text = "";
        if (uiCell != null) {
            int columnIndex = uiCell.getColumnIndex();
            ICell cell = this.getCell(element, columnIndex);
            if (cell != null && (text = cell.getTooltipText()) == null) {
                text = cell.getText();
                if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
                    text = HTMLUtility.getPlainText((String)text);
                }
                if (text == null || text.indexOf("\n") <= 0) {
                    text = "";
                }
            }
            text = StringUtility.wrapWord((String)text, (int)80);
        }
        return text;
    }

    public void consumeColumnModelEvent(RwtScoutTableEvent uiTableEvent) {
        this.rebuildCache();
    }

    protected ICell getCell(Object row, int colIndex) {
        IColumn<?> column = this.m_columnManager.getColumnByModelIndex(colIndex - 1);
        if (column != null) {
            if (this.m_cachedCells == null || this.m_cachedCells.get(row) == null) {
                this.rebuildCache();
            }
            return this.m_cachedCells.get(row).get(column);
        }
        return null;
    }

    private void rebuildCache() {
        this.m_cachedCells = new HashMap();
        if (this.getScoutTable() != null) {
            for (ITableRow scoutRow : this.getScoutTable().getRows()) {
                HashMap<IColumn, ICell> cells = new HashMap<IColumn, ICell>();
                for (IColumn col : this.getScoutTable().getColumnSet().getVisibleColumns()) {
                    cells.put(col, this.getScoutTable().getCell(scoutRow, col));
                }
                this.m_cachedCells.put(scoutRow, cells);
            }
        }
    }
}

