/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.tree;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.tree.IRwtScoutTree;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

public class RwtScoutTreeModel
extends LabelProvider
implements ITreeContentProvider,
IFontProvider,
IColorProvider {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTreeModel.class);
    private final ITree m_scoutTree;
    private final IRwtScoutTree m_uiTree;
    private final TreeViewer m_treeViewer;
    private Image m_imgCheckboxTrue;
    private Image m_imgCheckboxFalse;
    private Color m_disabledForegroundColor;
    private final IRwtEnvironment m_env;

    public RwtScoutTreeModel(ITree tree, IRwtScoutTree uiTree, TreeViewer treeViewer) {
        this.m_scoutTree = tree;
        this.m_uiTree = uiTree;
        this.m_treeViewer = treeViewer;
        this.m_env = this.getUiTree().getUiEnvironment();
        this.m_imgCheckboxTrue = this.m_env.getIcon("checkbox_yes");
        this.m_imgCheckboxFalse = this.m_env.getIcon("checkbox_no");
        this.m_disabledForegroundColor = this.m_env.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
    }

    protected ITree getScoutTree() {
        return this.m_scoutTree;
    }

    private IRwtScoutTree getUiTree() {
        return this.m_uiTree;
    }

    public Object[] getChildren(Object parentElement) {
        ITreeNode scoutNode = (ITreeNode)parentElement;
        return scoutNode.getFilteredChildNodes().toArray();
    }

    public Object getParent(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return scoutNode.getParentNode();
    }

    public boolean hasChildren(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return !scoutNode.isLeaf();
    }

    public Object[] getElements(Object inputElement) {
        if (this.getScoutTree() != null) {
            if (this.getScoutTree().isRootNodeVisible()) {
                return new Object[]{this.getScoutTree().getRootNode()};
            }
            return this.getScoutTree().getRootNode().getFilteredChildNodes().toArray();
        }
        return new Object[0];
    }

    public Image getImage(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode == null) {
            return null;
        }
        Image checkBoxImage = null;
        if (this.getScoutTree().isCheckable()) {
            checkBoxImage = scoutNode.isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        }
        String iconId = scoutNode.getCell().getIconId();
        Image decoImage = null;
        decoImage = this.m_env.getIcon(iconId);
        if (checkBoxImage != null && decoImage != null) {
            return checkBoxImage;
        }
        if (checkBoxImage != null) {
            return checkBoxImage;
        }
        if (decoImage != null) {
            return decoImage;
        }
        return null;
    }

    public String getText(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode == null || scoutNode.getCell() == null) {
            return "";
        }
        ICell cell = scoutNode.getCell();
        String text = StringUtility.nvl((Object)cell.getText(), (String)"");
        if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
            text = this.m_env.adaptHtmlCell(this.getUiTree(), text);
            text = this.m_env.convertLinksInHtmlCell(this.getUiTree(), text);
        } else {
            if (text.indexOf("\n") >= 0) {
                text = StringUtility.replaceNewLines((String)text, (String)" ");
            }
            if (cell.isHtmlEnabled() && RwtUtility.isMarkupEnabled((Widget)this.getUiTree().getUiField())) {
                return HtmlTextUtility.transformPlainTextToHtml(text);
            }
        }
        return HtmlTextUtility.validateHtmlCapableText(this.m_env.getHtmlValidator(), cell, text);
    }

    public Font getFont(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getFont() != null) {
            return this.m_env.getFont(scoutNode.getCell().getFont(), this.m_treeViewer.getTree().getFont());
        }
        return null;
    }

    public Color getForeground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        ICell scoutCell = scoutNode.getCell();
        Color col = this.m_env.getColor(scoutCell.getForegroundColor());
        if (col == null && !scoutCell.isEnabled()) {
            col = this.m_disabledForegroundColor;
        }
        return col;
    }

    public Color getBackground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getBackgroundColor() != null) {
            return this.m_env.getColor(scoutNode.getCell().getBackgroundColor());
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

