/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public abstract class RwtScoutBasicFieldComposite<T extends IBasicField<?>>
extends RwtScoutValueFieldComposite<T> {
    private boolean m_validateOnAnyKey;
    private P_RwtValidateOnAnyKeyModifyListener m_validateOnAnyKeyModifyListener;

    @Override
    protected void attachScout() {
        super.attachScout();
        IBasicField f = (IBasicField)this.getScoutObject();
        this.setValidateOnAnyKeyFromScout(f.isValidateOnAnyKey());
    }

    public Text getUiField() {
        return (Text)super.getUiField();
    }

    @Override
    protected void setDisplayTextFromScout(String newText) {
        Text field = this.getUiField();
        String oldText = field.getText();
        if (newText == null) {
            newText = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        if (oldText.equals(newText)) {
            return;
        }
        try {
            this.getUpdateUiFromScoutLock().acquire();
            int startIndex = field.getSelection().x;
            int endIndex = field.getSelection().y;
            if (startIndex == endIndex && newText.length() != oldText.length()) {
                if (startIndex >= oldText.length()) {
                    startIndex = newText.length();
                } else if (newText.endsWith(oldText.substring(startIndex))) {
                    startIndex = newText.length() - oldText.substring(startIndex).length();
                }
                endIndex = startIndex;
            }
            field.setText(newText);
            int textLength = field.getText().length();
            startIndex = Math.min(Math.max(startIndex, 0), textLength);
            endIndex = Math.min(Math.max(endIndex, 0), textLength);
            field.setSelection(startIndex, endIndex);
        }
        finally {
            this.getUpdateUiFromScoutLock().release();
        }
    }

    private void setValidateOnAnyKeyFromScout(boolean b) {
        this.m_validateOnAnyKey = b;
        if (b) {
            this.addValidateOnAnyKeyModifyListener();
        } else {
            this.removeValidateOnAnyKeyModifyListener();
        }
    }

    protected void addValidateOnAnyKeyModifyListener() {
        if (this.m_validateOnAnyKeyModifyListener == null) {
            this.m_validateOnAnyKeyModifyListener = new P_RwtValidateOnAnyKeyModifyListener();
            this.getUiField().addModifyListener((ModifyListener)this.m_validateOnAnyKeyModifyListener);
        }
    }

    protected void removeValidateOnAnyKeyModifyListener() {
        if (this.m_validateOnAnyKeyModifyListener != null) {
            this.getUiField().removeModifyListener((ModifyListener)this.m_validateOnAnyKeyModifyListener);
            this.m_validateOnAnyKeyModifyListener = null;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("validateOnAnyKey")) {
            this.setValidateOnAnyKeyFromScout((Boolean)newValue);
        }
    }

    @Override
    protected void handleUiInputVerifier(boolean doit) {
        if (!doit) {
            return;
        }
        final String text = this.getUiField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IBasicField)this.getScoutObject()).getDisplayText()) && ((IBasicField)this.getScoutObject()).getErrorStatus() == null) {
            return;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IBasicField)RwtScoutBasicFieldComposite.this.getScoutObject()).getUIFacade().setTextFromUI(text, false);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        doit = (Boolean)result.getValue();
        this.getUiEnvironment().dispatchImmediateUiJobs();
    }

    @Override
    protected void handleUiFocusGained() {
        super.handleUiFocusGained();
        if (this.isSelectAllOnFocusEnabled()) {
            this.getUiField().setSelection(0, this.getUiField().getText().length());
        }
    }

    private class P_RwtValidateOnAnyKeyModifyListener
    implements ModifyListener {
        private static final long serialVersionUID = 1L;

        private P_RwtValidateOnAnyKeyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!RwtScoutBasicFieldComposite.this.m_validateOnAnyKey) {
                return;
            }
            if (RwtScoutBasicFieldComposite.this.getUpdateUiFromScoutLock().isReleased()) {
                this.sendVerifyToScoutAndIgnoreResponses();
            }
        }

        private void sendVerifyToScoutAndIgnoreResponses() {
            final String text = RwtScoutBasicFieldComposite.this.getUiField().getText();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IBasicField)RwtScoutBasicFieldComposite.this.getScoutObject()).getUIFacade().setTextFromUI(text, true);
                }
            };
            RwtScoutBasicFieldComposite.this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }
}

