/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.snapbox.button;

import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RwtScoutMinimizedButton
extends RwtScoutComposite<IButton> {
    private OptimisticLock m_selectionLock = new OptimisticLock();

    @Override
    protected void initializeUi(Composite parent) {
        Button button = this.getUiEnvironment().getFormToolkit().createButton(parent, "", 2);
        this.setUiField((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RwtScoutMinimizedButton.this.handleUiSelection(RwtScoutMinimizedButton.this.getUiField().getSelection());
            }
        });
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setIconIdFromScout(((IButton)this.getScoutObject()).getIconId());
        this.setSelectionFormScout(((IButton)this.getScoutObject()).isSelected());
        this.getUiField().setToolTipText(((IButton)this.getScoutObject()).getLabel());
    }

    public Button getUiField() {
        return (Button)super.getUiField();
    }

    protected void setIconIdFromScout(String iconId) {
        this.getUiField().setImage(this.getUiEnvironment().getIcon(iconId));
    }

    private void handleUiSelection(final boolean selected) {
        try {
            if (this.m_selectionLock.acquire()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IButton)RwtScoutMinimizedButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(selected);
                    }
                };
                this.getUiEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void setSelectionFormScout(boolean selection) {
        try {
            if (this.m_selectionLock.acquire()) {
                this.getUiField().setSelection(selection);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("selected".equals(name)) {
            this.setSelectionFormScout((Boolean)newValue);
        } else if ("iconId".equals(name)) {
            this.setIconIdFromScout((String)newValue);
        } else {
            super.handleScoutPropertyChange(name, newValue);
        }
    }
}

