/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.tabbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.tabbox.IRwtScoutTabBox;
import org.eclipse.scout.rt.ui.rap.form.fields.tabbox.RwtScoutTabItem;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutTabBox
extends RwtScoutFieldComposite<ITabBox>
implements IRwtScoutTabBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTabBox.class);
    private HashMap<Composite, RwtScoutTabItem> m_tabs;
    private LinkedList<RwtScoutTabItem> m_tabList;
    private P_TabListener m_tabListener = new P_TabListener();
    private OptimisticLock m_selectedTabLock;
    private OptimisticLock m_rebuildItemsLock = new OptimisticLock();
    private Composite m_tabboxButtonbar;
    private StackLayout m_stackLayout;
    private Composite m_tabboxContainer;
    private RwtScoutTabItem m_selectedItem;

    public RwtScoutTabBox() {
        this.m_selectedTabLock = new OptimisticLock();
    }

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent, 128);
        container.setData("org.eclipse.rap.rwt.customVariant", (Object)"tabboxContainer");
        this.m_tabboxButtonbar = this.createTabboxButtonBar(container);
        this.m_tabboxContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 0);
        container.setLayout((Layout)RwtLayoutUtility.createGridLayoutNoSpacing(1, false));
        GridData tabboxButtonBarLayoutdata = new GridData(552);
        this.m_tabboxButtonbar.setLayoutData((Object)tabboxButtonBarLayoutdata);
        this.m_tabboxContainer.setLayoutData((Object)new GridData(1808));
        this.m_stackLayout = new StackLayout();
        this.m_tabboxContainer.setLayout((Layout)this.m_stackLayout);
        this.setUiLabel(null);
        this.setUiField((Control)this.m_tabboxContainer);
        this.setUiContainer(container);
        for (IGroupBox box : ((ITabBox)this.getScoutObject()).getGroupBoxes()) {
            box.addPropertyChangeListener((PropertyChangeListener)this.m_tabListener);
        }
        this.rebuildItems();
    }

    protected Composite createTabboxButtonBar(Composite parent) {
        Composite tabboxButtonBar = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        tabboxButtonBar.setData("org.eclipse.rap.rwt.customVariant", (Object)"tabboxContainer");
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginTop = 5;
        layout.marginLeft = 10;
        tabboxButtonBar.setLayout((Layout)layout);
        return tabboxButtonBar;
    }

    @Override
    protected void disposeImpl() {
        super.disposeImpl();
        if (this.m_tabboxButtonbar != null && !this.m_tabboxButtonbar.isDisposed()) {
            this.m_tabboxButtonbar.dispose();
            this.m_tabboxButtonbar = null;
        }
    }

    protected void rebuildItems() {
        try {
            this.m_rebuildItemsLock.acquire();
            this.getUiContainer().setRedraw(false);
            if (this.m_tabs != null) {
                for (RwtScoutTabItem item : this.m_tabs.values()) {
                    item.dispose();
                }
            }
            this.m_tabs = new HashMap();
            this.m_tabList = new LinkedList();
            for (IGroupBox box : ((ITabBox)this.getScoutObject()).getGroupBoxes()) {
                if (!box.isVisible()) continue;
                RwtScoutTabItem item = this.createUiTabItem(box);
                this.m_tabs.put(item.getTabItem(), item);
                this.m_tabList.addLast(item);
            }
            this.linkTabItems();
            this.setSelectedTabFromScout();
        }
        finally {
            this.getUiContainer().setRedraw(true);
            this.m_rebuildItemsLock.release();
        }
    }

    protected RwtScoutTabItem createUiTabItem(IGroupBox groupBox) {
        RwtScoutTabItem item = this.createUiTabItem();
        item.createUiField(this.getUiField(), groupBox, this.getUiEnvironment());
        return item;
    }

    private void linkTabItems() {
        if (this.m_tabList == null || this.m_tabList.size() == 0) {
            return;
        }
        RwtScoutTabItem previousItem = null;
        for (RwtScoutTabItem curItem : this.m_tabList) {
            if (previousItem != null) {
                curItem.setPreviousTabItem(previousItem);
                previousItem.setNextTabItem(curItem);
            }
            previousItem = curItem;
        }
        RwtScoutTabItem firstItem = this.m_tabList.getFirst();
        RwtScoutTabItem lastItem = this.m_tabList.getLast();
        firstItem.setPreviousTabItem(lastItem);
        lastItem.setNextTabItem(firstItem);
    }

    protected RwtScoutTabItem createUiTabItem() {
        return new RwtScoutTabItem((ITabBox)this.getScoutObject(), this.getTabboxButtonbar(), this.getTabboxContainer(), "tabboxButton", "tabboxButton-active", "tabboxButton-marked", "tabboxButton-active-marked");
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    public Composite getTabboxButtonbar() {
        return this.m_tabboxButtonbar;
    }

    public Composite getTabboxContainer() {
        return this.m_tabboxContainer;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setSelectedTabFromScout();
    }

    @Override
    protected void detachScout() {
        for (IGroupBox b : ((ITabBox)this.getScoutObject()).getGroupBoxes()) {
            b.removePropertyChangeListener((PropertyChangeListener)this.m_tabListener);
        }
        super.detachScout();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    protected void setSelectedTabFromScout() {
        try {
            this.m_selectedTabLock.acquire();
            IGroupBox selectedTab = ((ITabBox)this.getScoutObject()).getSelectedTab();
            RwtScoutTabItem foundItem = this.getTabItem(selectedTab);
            if (foundItem != null && foundItem.getTabItem() != null) {
                this.m_stackLayout.topControl = foundItem.getTabItem();
                this.m_tabboxContainer.layout();
                this.m_selectedItem = foundItem;
                for (RwtScoutTabItem item : this.m_tabList) {
                    if (item == this.m_selectedItem) continue;
                    item.unselect();
                }
                this.m_selectedItem.select();
                this.m_tabboxButtonbar.layout();
            }
        }
        finally {
            this.m_selectedTabLock.release();
        }
    }

    protected void setGroupBoxVisibleFromScout(final IGroupBox groupBox) {
        try {
            if (this.m_rebuildItemsLock.acquire()) {
                RunnableWithData t = new RunnableWithData(){

                    public void run() {
                        if (groupBox.isVisible()) {
                            RwtScoutTabBox.this.showGroupBox(groupBox);
                        } else {
                            RwtScoutTabBox.this.hideGroupBox(groupBox);
                        }
                    }
                };
                this.getUiEnvironment().invokeUiLater((Runnable)t);
            }
        }
        finally {
            this.m_rebuildItemsLock.release();
        }
    }

    protected void showGroupBox(IGroupBox groupBox) {
        this.getUiContainer().setRedraw(false);
        try {
            RwtScoutTabItem item = this.getTabItem(groupBox);
            if (item == null) {
                item = this.createUiTabItem(groupBox);
                this.m_tabs.put(item.getTabItem(), item);
                int index = this.getVisibleIndex(groupBox);
                this.m_tabList.add(index, item);
                this.linkTabItems();
                int i = index + 1;
                while (i < this.m_tabList.size()) {
                    this.m_tabList.get(i).recreateTabButton();
                    ++i;
                }
                this.m_tabboxButtonbar.layout();
            }
        }
        finally {
            this.getUiContainer().setRedraw(true);
        }
    }

    protected void hideGroupBox(IGroupBox groupBox) {
        this.getUiContainer().setRedraw(false);
        try {
            RwtScoutTabItem item = this.getTabItem(groupBox);
            if (item != null) {
                this.m_tabs.remove(item.getTabItem());
                this.m_tabList.remove(item);
                this.linkTabItems();
                item.dispose();
                int i = 0;
                while (i < this.m_tabList.size()) {
                    this.m_tabList.get(i).recreateTabButton();
                    ++i;
                }
                this.m_tabboxButtonbar.layout();
            }
        }
        finally {
            this.getUiContainer().setRedraw(true);
        }
    }

    protected RwtScoutTabItem getTabItem(IGroupBox groupBox) {
        for (Map.Entry<Composite, RwtScoutTabItem> e : this.m_tabs.entrySet()) {
            IGroupBox test = (IGroupBox)e.getValue().getScoutObject();
            if (test != groupBox) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    protected void updateKeyStrokesFromScout() {
    }

    private int getVisibleIndex(IGroupBox groupBox) {
        int result = -1;
        if (groupBox == null || groupBox.getParentField() == null) {
            return result;
        }
        for (IFormField box : groupBox.getParentField().getFields()) {
            if (!box.isVisible()) continue;
            ++result;
            if (box == groupBox) break;
        }
        return result;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selectedTab")) {
            this.setSelectedTabFromScout();
        }
    }

    private class P_TabListener
    implements PropertyChangeListener {
        private P_TabListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                IGroupBox groupBox = (IGroupBox)evt.getSource();
                RwtScoutTabBox.this.setGroupBoxVisibleFromScout(groupBox);
            }
        }
    }
}

