/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.keystroke;

import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.widgets.Event;

public class RwtScoutKeyStroke
extends RwtKeyStroke {
    private final IKeyStroke m_scoutKeyStroke;
    private final IRwtEnvironment m_uiEnvironment;
    private boolean m_handleActionPending;

    public RwtScoutKeyStroke(IKeyStroke scoutKeyStroke, IRwtEnvironment uiEnvironment, int keyCode, int stateMask) {
        super(keyCode, stateMask);
        this.m_scoutKeyStroke = scoutKeyStroke;
        this.m_uiEnvironment = uiEnvironment;
    }

    @Override
    public void handleUiAction(Event e) {
        if (this.getScoutKeyStroke().isEnabled() && this.getScoutKeyStroke().isVisible()) {
            RwtUtility.runUiInputVerifier();
            if (!this.m_handleActionPending) {
                this.m_handleActionPending = true;
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RwtScoutKeyStroke.this.getScoutKeyStroke().getUIFacade().fireActionFromUI();
                        }
                        finally {
                            RwtScoutKeyStroke.this.m_handleActionPending = false;
                        }
                    }
                };
                this.getUiEnvironment().invokeScoutLater(job, 0L);
            }
            e.doit = false;
        }
    }

    public IKeyStroke getScoutKeyStroke() {
        return this.m_scoutKeyStroke;
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }
}

