/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class RwtIconLocator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtIconLocator.class);
    private final ImageRegistry imageRegistry;
    private final Set<String> m_missingImages = new HashSet<String>();
    private final IIconLocator m_iconLocator;

    public RwtIconLocator(IIconLocator iconLocator) {
        this.m_iconLocator = iconLocator;
        this.imageRegistry = new ImageRegistry();
    }

    public ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.m_missingImages.contains(name)) {
            return null;
        }
        ImageDescriptor desc = this.imageRegistry.getDescriptor(name);
        if (desc == null) {
            desc = this.createImageDescriptor(name);
            if (desc == null) {
                this.m_missingImages.add(name);
            } else {
                this.imageRegistry.put(name, desc);
            }
        }
        return desc;
    }

    public Image getIcon(String name) {
        if (name == null || "null".equals(name)) {
            return null;
        }
        if (this.m_missingImages.contains(name)) {
            return null;
        }
        Image image = this.imageRegistry.get(name);
        if (image != null && image.isDisposed()) {
            this.imageRegistry.remove(name);
        }
        if (image == null || image.isDisposed()) {
            Image desc = this.createImage(name);
            if (desc != null) {
                this.imageRegistry.put(name, desc);
                image = desc;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("image found '" + name + "'.");
                }
            } else {
                LOG.warn("image '" + name + "' could not be found!");
                this.m_missingImages.add(name);
            }
        }
        return image;
    }

    protected Image createImage(String name) {
        IconSpec spec = this.m_iconLocator.getIconSpec(name);
        if (spec != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("image found '" + name + "'.");
            }
            return new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(spec.getContent()));
        }
        LOG.warn("image '" + name + "' could not be found!");
        this.m_missingImages.add(name);
        return null;
    }

    protected ImageDescriptor createImageDescriptor(String name) {
        ImageDescriptor desc = null;
        IconSpec spec = this.m_iconLocator.getIconSpec(name);
        if (spec != null) {
            desc = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)new ByteArrayInputStream(spec.getContent())));
            if (LOG.isDebugEnabled()) {
                LOG.debug("image found '" + name + "'.");
            }
        } else {
            LOG.warn("image '" + name + "' could not be found!");
            this.m_missingImages.add(name);
        }
        return desc;
    }

    public void dispose() {
        this.imageRegistry.dispose();
    }
}

