/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.dnd.ClientFileTransfer;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.dnd.FileListTransferObject;
import org.eclipse.scout.commons.dnd.ImageTransferObject;
import org.eclipse.scout.commons.dnd.JavaTransferObject;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtScoutKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfoBuilder;
import org.eclipse.scout.rt.ui.rap.util.JVMLocalObjectTransfer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class RwtUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtUtility.class);
    public static final boolean VALIDATE_HTML_CAPABLE = BundleContextUtility.parseBooleanProperty((String)"scout.ui.rap.validate.htmlCapable", (boolean)true);
    public static final String BROWSER_INFO = "browser-Info";
    public static final String VARIANT_PROPOSAL_FORM = "proposal-form";
    public static final String VARIANT_LISTBOX = "listbox";
    public static final String VARIANT_LISTBOX_DISABLED = "listboxDisabled";
    public static final String VARIANT_EMPTY = "empty";
    public static final String VARIANT_COMPOSITE_INPUT_FIELD_BORDER = "inputField";
    public static final String VARIANT_COMPOSITE_INPUT_FIELD_BORDER_READONLY = "inputField-readOnly";
    private static final Map<String, Integer> SCOUT_RWT_KEY_MAP = new HashMap<String, Integer>();
    private static final Map<Integer, String> RWT_SCOUT_KEY_MAP = new HashMap<Integer, String>();
    public static final String EXTENDED_STYLE = "extendedStyle";
    private static final Pattern MNEMONIC_PATTERN;

    static {
        SCOUT_RWT_KEY_MAP.put("enter", 13);
        SCOUT_RWT_KEY_MAP.put("back_space", 8);
        SCOUT_RWT_KEY_MAP.put("tab", 9);
        SCOUT_RWT_KEY_MAP.put("shift", 131072);
        SCOUT_RWT_KEY_MAP.put("control", 262144);
        SCOUT_RWT_KEY_MAP.put("alt", 65536);
        SCOUT_RWT_KEY_MAP.put("alternate", 65536);
        SCOUT_RWT_KEY_MAP.put("pause", 0x1000055);
        SCOUT_RWT_KEY_MAP.put("caps_lock", 16777298);
        SCOUT_RWT_KEY_MAP.put("escape", 27);
        SCOUT_RWT_KEY_MAP.put("space", 32);
        SCOUT_RWT_KEY_MAP.put("page_up", 0x1000005);
        SCOUT_RWT_KEY_MAP.put("page_down", 0x1000006);
        SCOUT_RWT_KEY_MAP.put("end", 0x1000008);
        SCOUT_RWT_KEY_MAP.put("home", 0x1000007);
        SCOUT_RWT_KEY_MAP.put("left", 0x1000003);
        SCOUT_RWT_KEY_MAP.put("up", 0x1000001);
        SCOUT_RWT_KEY_MAP.put("right", 0x1000004);
        SCOUT_RWT_KEY_MAP.put("down", 0x1000002);
        SCOUT_RWT_KEY_MAP.put("multiply", 16777258);
        SCOUT_RWT_KEY_MAP.put("add", 16777259);
        SCOUT_RWT_KEY_MAP.put("separater", 0x1000050);
        SCOUT_RWT_KEY_MAP.put("subtract", 16777261);
        SCOUT_RWT_KEY_MAP.put("decimal", 16777262);
        SCOUT_RWT_KEY_MAP.put("divide", 16777263);
        SCOUT_RWT_KEY_MAP.put("delete", 127);
        SCOUT_RWT_KEY_MAP.put("num_lock", 16777299);
        SCOUT_RWT_KEY_MAP.put("scroll_lock", 16777300);
        SCOUT_RWT_KEY_MAP.put("f1", 0x100000A);
        SCOUT_RWT_KEY_MAP.put("f2", 0x100000B);
        SCOUT_RWT_KEY_MAP.put("f3", 0x100000C);
        SCOUT_RWT_KEY_MAP.put("f4", 0x100000D);
        SCOUT_RWT_KEY_MAP.put("f5", 0x100000E);
        SCOUT_RWT_KEY_MAP.put("f6", 0x100000F);
        SCOUT_RWT_KEY_MAP.put("f7", 0x1000010);
        SCOUT_RWT_KEY_MAP.put("f8", 0x1000011);
        SCOUT_RWT_KEY_MAP.put("f9", 0x1000012);
        SCOUT_RWT_KEY_MAP.put("f10", 0x1000013);
        SCOUT_RWT_KEY_MAP.put("f11", 0x1000014);
        SCOUT_RWT_KEY_MAP.put("f12", 0x1000015);
        SCOUT_RWT_KEY_MAP.put("f13", 0x1000016);
        SCOUT_RWT_KEY_MAP.put("f14", 0x1000017);
        SCOUT_RWT_KEY_MAP.put("f15", 0x1000018);
        SCOUT_RWT_KEY_MAP.put("printscreen", 16777303);
        SCOUT_RWT_KEY_MAP.put("insert", 0x1000009);
        SCOUT_RWT_KEY_MAP.put("help", 0x1000051);
        SCOUT_RWT_KEY_MAP.put("ampersand", 38);
        SCOUT_RWT_KEY_MAP.put("less", 60);
        SCOUT_RWT_KEY_MAP.put("greater", 62);
        SCOUT_RWT_KEY_MAP.put("at", 64);
        SCOUT_RWT_KEY_MAP.put("colon", 513);
        SCOUT_RWT_KEY_MAP.put("circumflex", 94);
        SCOUT_RWT_KEY_MAP.put("dollar", 36);
        SCOUT_RWT_KEY_MAP.put("euro_sign", 128);
        SCOUT_RWT_KEY_MAP.put("exclamation_mark", 33);
        SCOUT_RWT_KEY_MAP.put("inverted_exclamation_mark", 161);
        SCOUT_RWT_KEY_MAP.put("left_parenthesis", 40);
        SCOUT_RWT_KEY_MAP.put("number_sign", 35);
        SCOUT_RWT_KEY_MAP.put("minus", 45);
        SCOUT_RWT_KEY_MAP.put("plus", 43);
        SCOUT_RWT_KEY_MAP.put("right_parenthesis", 41);
        SCOUT_RWT_KEY_MAP.put("underscore", 95);
        SCOUT_RWT_KEY_MAP.put("undo", 65483);
        RWT_SCOUT_KEY_MAP.put(13, "enter");
        RWT_SCOUT_KEY_MAP.put(8, "back_space");
        RWT_SCOUT_KEY_MAP.put(9, "tab");
        RWT_SCOUT_KEY_MAP.put(131072, "shift");
        RWT_SCOUT_KEY_MAP.put(262144, "control");
        RWT_SCOUT_KEY_MAP.put(65536, "alt");
        RWT_SCOUT_KEY_MAP.put(0x1000055, "pause");
        RWT_SCOUT_KEY_MAP.put(16777298, "caps_lock");
        RWT_SCOUT_KEY_MAP.put(27, "escape");
        RWT_SCOUT_KEY_MAP.put(32, "space");
        RWT_SCOUT_KEY_MAP.put(0x1000005, "page_up");
        RWT_SCOUT_KEY_MAP.put(0x1000006, "page_down");
        RWT_SCOUT_KEY_MAP.put(0x1000008, "end");
        RWT_SCOUT_KEY_MAP.put(0x1000007, "home");
        RWT_SCOUT_KEY_MAP.put(0x1000003, "left");
        RWT_SCOUT_KEY_MAP.put(0x1000001, "up");
        RWT_SCOUT_KEY_MAP.put(0x1000004, "right");
        RWT_SCOUT_KEY_MAP.put(0x1000002, "down");
        RWT_SCOUT_KEY_MAP.put(16777258, "multiply");
        RWT_SCOUT_KEY_MAP.put(16777259, "add");
        RWT_SCOUT_KEY_MAP.put(0x1000050, "separater");
        RWT_SCOUT_KEY_MAP.put(16777261, "subtract");
        RWT_SCOUT_KEY_MAP.put(16777262, "decimal");
        RWT_SCOUT_KEY_MAP.put(16777263, "divide");
        RWT_SCOUT_KEY_MAP.put(127, "delete");
        RWT_SCOUT_KEY_MAP.put(16777299, "num_lock");
        RWT_SCOUT_KEY_MAP.put(16777300, "scroll_lock");
        RWT_SCOUT_KEY_MAP.put(0x100000A, "f1");
        RWT_SCOUT_KEY_MAP.put(0x100000B, "f2");
        RWT_SCOUT_KEY_MAP.put(0x100000C, "f3");
        RWT_SCOUT_KEY_MAP.put(0x100000D, "f4");
        RWT_SCOUT_KEY_MAP.put(0x100000E, "f5");
        RWT_SCOUT_KEY_MAP.put(0x100000F, "f6");
        RWT_SCOUT_KEY_MAP.put(0x1000010, "f7");
        RWT_SCOUT_KEY_MAP.put(0x1000011, "f8");
        RWT_SCOUT_KEY_MAP.put(0x1000012, "f9");
        RWT_SCOUT_KEY_MAP.put(0x1000013, "f10");
        RWT_SCOUT_KEY_MAP.put(0x1000014, "f11");
        RWT_SCOUT_KEY_MAP.put(0x1000015, "f12");
        RWT_SCOUT_KEY_MAP.put(0x1000016, "f13");
        RWT_SCOUT_KEY_MAP.put(0x1000017, "f14");
        RWT_SCOUT_KEY_MAP.put(0x1000018, "f15");
        RWT_SCOUT_KEY_MAP.put(16777303, "printscreen");
        RWT_SCOUT_KEY_MAP.put(0x1000009, "insert");
        RWT_SCOUT_KEY_MAP.put(0x1000051, "help");
        RWT_SCOUT_KEY_MAP.put(38, "ampersand");
        RWT_SCOUT_KEY_MAP.put(60, "less");
        RWT_SCOUT_KEY_MAP.put(62, "greater");
        RWT_SCOUT_KEY_MAP.put(64, "at");
        RWT_SCOUT_KEY_MAP.put(513, "colon");
        RWT_SCOUT_KEY_MAP.put(94, "circumflex");
        RWT_SCOUT_KEY_MAP.put(36, "dollar");
        RWT_SCOUT_KEY_MAP.put(128, "euro_sign");
        RWT_SCOUT_KEY_MAP.put(33, "exclamation_mark");
        RWT_SCOUT_KEY_MAP.put(161, "inverted_exclamation_mark");
        RWT_SCOUT_KEY_MAP.put(40, "left_parenthesis");
        RWT_SCOUT_KEY_MAP.put(35, "number_sign");
        RWT_SCOUT_KEY_MAP.put(45, "minus");
        RWT_SCOUT_KEY_MAP.put(43, "plus");
        SCOUT_RWT_KEY_MAP.put("right_parenthesis", 41);
        RWT_SCOUT_KEY_MAP.put(95, "underscore");
        RWT_SCOUT_KEY_MAP.put(65483, "undo");
        MNEMONIC_PATTERN = Pattern.compile("(\\&)", 32);
    }

    private RwtUtility() {
    }

    public static IRwtEnvironment getUiEnvironment(IClientSession session) {
        IRwtEnvironment env = (IRwtEnvironment)session.getData("ui.environment");
        return env;
    }

    public static IRwtEnvironment getUiEnvironment(Display display) {
        IRwtEnvironment env = (IRwtEnvironment)display.getData(IRwtEnvironment.class.getName());
        return env;
    }

    public static Locale getClientSessionLocale(Display display) {
        return RwtUtility.getUiEnvironment(display).getClientSession().getLocale();
    }

    public static BrowserInfo getBrowserInfo() {
        BrowserInfo info = (BrowserInfo)RWT.getUISession().getAttribute(BROWSER_INFO);
        if (info == null) {
            HttpServletRequest request = RWT.getRequest();
            info = RwtUtility.createBrowserInfo(request);
            RWT.getUISession().setAttribute(BROWSER_INFO, (Object)info);
        }
        return info;
    }

    public static BrowserInfo createBrowserInfo(HttpServletRequest request) {
        return new BrowserInfoBuilder().createBrowserInfo(request);
    }

    public static Object createUiTransferable(TransferObject scoutT) {
        if (scoutT == null) {
            return null;
        }
        if (scoutT instanceof FileListTransferObject) {
            return ((FileListTransferObject)scoutT).getFilenames();
        }
        if (scoutT instanceof TextTransferObject) {
            return ((TextTransferObject)scoutT).getPlainText();
        }
        if (scoutT instanceof JavaTransferObject) {
            return ((JavaTransferObject)scoutT).getLocalObject();
        }
        if (scoutT instanceof ImageTransferObject) {
            Object image = ((ImageTransferObject)scoutT).getImage();
            if (image instanceof byte[]) {
                ByteArrayInputStream imageInput = new ByteArrayInputStream((byte[])image);
                Image img = new Image(null, (InputStream)imageInput);
                if (img != null) {
                    return img.getImageData();
                }
            } else if (image instanceof ImageData) {
                return image;
            }
        }
        return null;
    }

    public static TransferObject createScoutTransferable(DropTargetEvent event) {
        block15: {
            String transferData;
            if (event == null || event.currentDataType == null) {
                return null;
            }
            Exception ex = null;
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                String[] fileNames = (String[])event.data;
                ArrayList<File> files = new ArrayList<File>();
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        String fileName = stringArray[n2];
                        try {
                            files.add(new File(fileName));
                        }
                        catch (Exception e) {
                            if (ex != null) break block14;
                            ex = e;
                        }
                    }
                    ++n2;
                }
                return new FileListTransferObject(files);
            }
            if (JVMLocalObjectTransfer.getInstance().isSupportedType(event.currentDataType) && !(event.data instanceof String)) {
                Object transferData2 = event.data;
                if (transferData2 != null) {
                    try {
                        return new JavaTransferObject(transferData2);
                    }
                    catch (Exception e) {
                        if (ex == null) {
                            ex = e;
                        }
                    }
                }
            } else if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (transferData = (String)event.data) != null) {
                try {
                    return new TextTransferObject(transferData);
                }
                catch (Exception e) {
                    if (ex != null) break block15;
                    ex = e;
                }
            }
        }
        return null;
    }

    public static TransferObject createScoutTransferableFromClientFile(DropTargetEvent event, List<File> uploadedFiles) {
        if (event == null || event.currentDataType == null) {
            return null;
        }
        FileListTransferObject scoutTransferObject = null;
        if (ClientFileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            scoutTransferObject = new FileListTransferObject(uploadedFiles);
        }
        return scoutTransferObject;
    }

    public static Transfer[] convertScoutTransferTypes(int scoutTransferTypes) {
        ArrayList<Object> uiTransferList = new ArrayList<Object>();
        boolean addClientFileTransfer = false;
        if ((1 & scoutTransferTypes) != 0) {
            uiTransferList.add(FileTransfer.getInstance());
            addClientFileTransfer = true;
        }
        if ((8 & scoutTransferTypes) != 0) {
            uiTransferList.add(ImageTransfer.getInstance());
            addClientFileTransfer = true;
        }
        if ((2 & scoutTransferTypes) != 0) {
            uiTransferList.add((Object)JVMLocalObjectTransfer.getInstance());
        }
        if ((4 & scoutTransferTypes) != 0) {
            uiTransferList.add(TextTransfer.getInstance());
        }
        if (addClientFileTransfer) {
            uiTransferList.add(ClientFileTransfer.getInstance());
        }
        return uiTransferList.toArray(new Transfer[uiTransferList.size()]);
    }

    public static int getHorizontalAlignment(int scoutAlignment) {
        if (scoutAlignment < 0) {
            return 16384;
        }
        if (scoutAlignment == 0) {
            return 0x1000000;
        }
        return 131072;
    }

    public static int getVerticalAlignment(int scoutAlignment) {
        if (scoutAlignment < 0) {
            return 128;
        }
        if (scoutAlignment == 0) {
            return 0;
        }
        return 1024;
    }

    public static Point getLocationOnScreen(Control c) {
        Point p = c.toDisplay(0, 0);
        return p;
    }

    public static boolean isAncestorOf(Control ancestor, Control child) {
        if (ancestor == null || child == null) {
            return false;
        }
        if (ancestor == child) {
            return true;
        }
        return RwtUtility.isAncestorOf(ancestor, (Control)child.getParent());
    }

    public static Rectangle getFullScreenBoundsFor(Display d, Rectangle r, boolean includeReservedInsets) {
        TreeMap<Integer, Rectangle> prioMap = new TreeMap<Integer, Rectangle>();
        Monitor[] monitorArray = d.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor dev = monitorArray[n2];
            Rectangle bounds = !includeReservedInsets ? dev.getClientArea() : dev.getBounds();
            Rectangle intersection = bounds.intersection(r);
            prioMap.put(intersection.width * intersection.height, bounds);
            if (dev == d.getPrimaryMonitor()) {
                prioMap.put(-1, bounds);
            }
            ++n2;
        }
        return (Rectangle)prioMap.get(prioMap.lastKey());
    }

    public static Rectangle validateRectangleOnScreen(Display d, Rectangle r, boolean includeReservedInsets, boolean singleMonitor) {
        Rectangle t = RwtUtility.intersectRectangleWithScreen(d, r, includeReservedInsets, singleMonitor);
        if (!t.equals((Object)r)) {
            Rectangle a = r;
            Rectangle screen = RwtUtility.intersectRectangleWithScreen(d, new Rectangle(-100000, -100000, 200000, 200000), includeReservedInsets, singleMonitor);
            if (screen.width < a.width) {
                a.width = screen.width;
            }
            if (screen.height < a.height) {
                a.height = screen.height;
            }
            if (a.x < screen.x) {
                a.x = screen.x;
            }
            if (a.y < screen.y) {
                a.y = screen.y;
            }
            if (a.x + a.width > screen.x + screen.width) {
                a.x = screen.x + screen.width - a.width;
            }
            if (a.y + a.height > screen.y + screen.height) {
                a.y = screen.y + screen.height - a.height;
            }
            return a;
        }
        return r;
    }

    public static Rectangle intersectRectangleWithScreen(Display d, Rectangle r, boolean includeReservedInsets, boolean singleMonitor) {
        if (singleMonitor) {
            return r.intersection(RwtUtility.getFullScreenBoundsFor(d, r, includeReservedInsets));
        }
        ArrayList<Rectangle> intersections = new ArrayList<Rectangle>();
        Monitor[] monitorArray = d.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor dev = monitorArray[n2];
            Rectangle bounds = !includeReservedInsets ? dev.getClientArea() : dev.getBounds();
            Rectangle intersection = bounds.intersection(r);
            if (!intersection.isEmpty()) {
                intersections.add(intersection);
            }
            ++n2;
        }
        if (intersections.size() > 0) {
            Rectangle unionAll = null;
            for (Rectangle i : intersections) {
                unionAll = unionAll == null ? i : unionAll.union(i);
            }
            return unionAll;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static <T extends Widget> T findChildComponent(Widget parent, Class<T> type) {
        ArrayList list = new ArrayList(1);
        RwtUtility.findChildComponentsRec(parent, type, null, list, 1);
        if (list.size() > 0) {
            return (T)((Widget)list.get(0));
        }
        return null;
    }

    public static <T extends Widget> T findChildComponent(Widget parent, Class<T> type, Class<? extends Widget> excludedType) {
        ArrayList list = new ArrayList(1);
        RwtUtility.findChildComponentsRec(parent, type, excludedType, list, 1);
        if (list.size() > 0) {
            return (T)((Widget)list.get(0));
        }
        return null;
    }

    public static <T extends Widget> List<T> findChildComponents(Widget parent, Class<T> type) {
        ArrayList list = new ArrayList();
        RwtUtility.findChildComponentsRec(parent, type, null, list, Integer.MAX_VALUE);
        return list;
    }

    public static <T extends Widget> List<T> findChildComponents(Widget parent, Class<T> type, Class<? extends Widget> excludedType) {
        ArrayList list = new ArrayList();
        RwtUtility.findChildComponentsRec(parent, type, excludedType, list, Integer.MAX_VALUE);
        return list;
    }

    private static <T extends Widget> void findChildComponentsRec(Widget parent, Class<T> type, Class<? extends Widget> excludedType, List<T> list, int maxCount) {
        if (type.isAssignableFrom(parent.getClass()) && (excludedType == null || !excludedType.isAssignableFrom(parent.getClass()))) {
            list.add(parent);
            if (list.size() >= maxCount) {
                return;
            }
        }
        if (parent instanceof Composite) {
            Control[] controlArray = ((Composite)parent).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                RwtUtility.findChildComponentsRec((Widget)c, type, excludedType, list, maxCount);
                if (list.size() >= maxCount) {
                    return;
                }
                ++n2;
            }
        }
    }

    public static boolean isPopupShell(Shell shell) {
        int style = shell.getStyle();
        Integer extendedStyle = (Integer)shell.getData(EXTENDED_STYLE);
        if (extendedStyle != null) {
            style |= extendedStyle.intValue();
        }
        return (style & 8) != 0;
    }

    public static <T> List<T> getItemsOfSelection(Class<T> t, StructuredSelection selection) {
        ArrayList result = new ArrayList();
        if (selection != null) {
            Iterator selectionIt = selection.iterator();
            while (selectionIt.hasNext()) {
                result.add(selectionIt.next());
            }
        }
        return result;
    }

    public static void setNlsTextsOnDisplay(Display display, ScoutTexts textProvider) {
        display.setData(ScoutTexts.JOB_PROPERTY_NAME.toString(), (Object)textProvider);
    }

    public static String getNlsText(Display display, String key, String ... messageArguments) {
        ScoutTexts textProvider;
        if (display != null && (textProvider = (ScoutTexts)display.getData(ScoutTexts.JOB_PROPERTY_NAME.toString())) != null) {
            return textProvider.getText(key, messageArguments);
        }
        return ScoutTexts.get((String)key, (String[])messageArguments);
    }

    public static TableColumn getRwtColumnAt(Table table, Point p) {
        int x = p.x;
        if (table.getHorizontalBar() != null) {
            x += table.getHorizontalBar().getSelection();
        }
        int[] nArray = table.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableColumn col = table.getColumn(index);
            if (col != null) {
                if (x >= 0 && x <= col.getWidth()) {
                    return col;
                }
                x -= col.getWidth();
            }
            ++n2;
        }
        return null;
    }

    public static MouseButton rwtToScoutMouseButton(int rwtButton) {
        switch (rwtButton) {
            case 1: {
                return MouseButton.Left;
            }
            case 3: {
                return MouseButton.Right;
            }
        }
        return MouseButton.Unknown;
    }

    public static IRwtKeyStroke[] getKeyStrokes(IKeyStroke stroke, IRwtEnvironment uiEnvironment) {
        ArrayList<RwtScoutKeyStroke> uiKeyStrokes = new ArrayList<RwtScoutKeyStroke>();
        int keycode = RwtUtility.getRwtKeyCode(stroke);
        int stateMask = RwtUtility.getRwtStateMask(stroke);
        if (keycode == 13) {
            uiKeyStrokes.add(new RwtScoutKeyStroke(stroke, uiEnvironment, 13, stateMask));
            uiKeyStrokes.add(new RwtScoutKeyStroke(stroke, uiEnvironment, 0x1000050, stateMask));
        } else {
            uiKeyStrokes.add(new RwtScoutKeyStroke(stroke, uiEnvironment, keycode, stateMask));
        }
        return uiKeyStrokes.toArray(new IRwtKeyStroke[uiKeyStrokes.size()]);
    }

    public static int getRwtStateMask(IKeyStroke stoke) {
        String[] a = stoke.getKeyStroke().split("-");
        int stateMask = 0;
        if (a.length > 1) {
            int i = 0;
            while (i < a.length - 1) {
                stateMask |= RwtUtility.scoutToRwtKey(a[i]);
                ++i;
            }
        }
        return stateMask;
    }

    public static int getRwtKeyCode(IKeyStroke keyStroke) {
        String[] keys = keyStroke.getKeyStroke().split("-");
        int rwtKeyCode = 0;
        if (keys.length > 0) {
            rwtKeyCode = RwtUtility.scoutToRwtKey(keys[keys.length - 1]);
        }
        return rwtKeyCode;
    }

    public static int scoutToRwtKey(String scoutKey) {
        Integer i = SCOUT_RWT_KEY_MAP.get(scoutKey);
        if (i == null) {
            if (scoutKey.length() != 1) {
                LOG.warn("no key mapping for: " + scoutKey);
                return 0;
            }
            return scoutKey.charAt(0);
        }
        return i;
    }

    public static String getKeyTextFor(KeyEvent e) {
        if (e.keyCode == 0) {
            return null;
        }
        String keyText = RwtUtility.getKeyTextUpper(e.keyCode);
        if (keyText == null) {
            return null;
        }
        if (keyText.equals("shift")) {
            return null;
        }
        if (keyText.equals("ctrl")) {
            return null;
        }
        if (keyText.equals("alt")) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if ((e.stateMask & 0x20000) != 0) {
            buf.append("shift-");
        }
        if ((e.stateMask & 0x40000) != 0) {
            buf.append("ctrl-");
        }
        if ((e.stateMask & 0x10000) != 0) {
            buf.append("alt-");
        }
        buf.append(keyText);
        return buf.toString();
    }

    public static String getKeyTextUpper(int keyCode) {
        if (keyCode >= 65 && keyCode <= 90) {
            return "";
        }
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 97 && keyCode <= 122) {
            return String.valueOf(Character.toUpperCase((char)keyCode));
        }
        int index = ",./\\[]`'".indexOf(keyCode);
        if (index >= 0) {
            return String.valueOf((char)keyCode);
        }
        if (keyCode >= 0x1000030 && keyCode <= 16777273) {
            return String.valueOf((char)(keyCode - 0x1000030 + 48));
        }
        switch (keyCode) {
            case 13: {
                return "RETURN";
            }
            case 8: {
                return "BACKSPACE";
            }
            case 9: {
                return "TAB";
            }
            case 65536: {
                return "ALT";
            }
            case 27: {
                return "ESCAPE";
            }
            case 32: {
                return "SPACE";
            }
            case 0x1000005: {
                return "PAGE_UP";
            }
            case 0x1000006: {
                return "PAGE_DOWN";
            }
            case 0x1000008: {
                return "END";
            }
            case 0x1000007: {
                return "HOME";
            }
            case 0x1000003: {
                return "ARROW_LEFT";
            }
            case 0x1000001: {
                return "ARROW_UP";
            }
            case 0x1000004: {
                return "ARROW_RIGHT";
            }
            case 0x1000002: {
                return "ARROW_DOWN";
            }
            case 16777258: {
                return "NUMPAD_MULTIPLY";
            }
            case 16777259: {
                return "NUMPAD_ADD";
            }
            case 0x1000050: {
                return "RETURN";
            }
            case 16777261: {
                return "NUMPAD_SUBTRACT";
            }
            case 16777262: {
                return "NUMPAD_DECIMAL";
            }
            case 16777263: {
                return "NUMPAD_DIVIDE";
            }
            case 127: {
                return "DELETE";
            }
            case 0x100000A: {
                return "F1";
            }
            case 0x100000B: {
                return "F2";
            }
            case 0x100000C: {
                return "F3";
            }
            case 0x100000D: {
                return "F4";
            }
            case 0x100000E: {
                return "F5";
            }
            case 0x100000F: {
                return "F6";
            }
            case 0x1000010: {
                return "F7";
            }
            case 0x1000011: {
                return "F8";
            }
            case 0x1000012: {
                return "F9";
            }
            case 0x1000013: {
                return "F10";
            }
            case 0x1000014: {
                return "F11";
            }
            case 0x1000015: {
                return "F12";
            }
            case 0x1000009: {
                return "INSERT";
            }
        }
        return "" + (char)keyCode;
    }

    public static boolean handleNavigationKey(Widget w, int keyCode) {
        if (w instanceof Tree) {
            return RwtUtility.handleNavigationKeyOnTree((Tree)w, keyCode);
        }
        if (w instanceof Table) {
            return RwtUtility.handleNavigationKeyOnTable((Table)w, keyCode);
        }
        return false;
    }

    public static boolean handleNavigationKeyOnTree(Tree tree, int keyCode) {
        if (tree != null && tree.getItemCount() > 0) {
            TreeItem[] a = tree.getSelection();
            TreeItem selItem = a != null && a.length > 0 ? a[0] : null;
            TreeItem next = null;
            switch (keyCode) {
                case 0x1000002: {
                    if (selItem == null) {
                        next = tree.getItem(0);
                        break;
                    }
                    next = RwtUtility.getNextTreeRow(tree, selItem);
                    break;
                }
                case 0x1000001: {
                    if (selItem == null) {
                        next = RwtUtility.getLastTreeRow(tree);
                        break;
                    }
                    next = RwtUtility.getPreviousTreeRow(tree, selItem);
                    break;
                }
                case 0x1000006: {
                    break;
                }
            }
            if (next != null) {
                tree.setSelection(next);
                Event selE = new Event();
                selE.type = 13;
                selE.item = next;
                selE.widget = tree;
                Listener[] listenerArray = tree.getListeners(13);
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener l = listenerArray[n2];
                    l.handleEvent(selE);
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean handleNavigationKeyOnTable(Table table, int keyCode) {
        if (table != null && table.getItemCount() > 0) {
            int count = table.getItemCount();
            TableItem[] a = table.getSelection();
            TableItem selItem = a != null && a.length > 0 ? a[0] : null;
            int selIndex = table.getSelectionIndex();
            TableItem next = null;
            switch (keyCode) {
                case 0x1000002: {
                    if (selItem == null) {
                        next = table.getItem(0);
                        break;
                    }
                    if (selIndex + 1 >= count) break;
                    next = table.getItem(selIndex + 1);
                    break;
                }
                case 0x1000001: {
                    if (selItem == null) {
                        next = table.getItem(count - 1);
                        break;
                    }
                    if (selIndex - 1 < 0) break;
                    next = table.getItem(selIndex - 1);
                    break;
                }
                case 0x1000006: {
                    if (selItem == null) {
                        next = table.getItem(0);
                        table.setTopIndex(table.indexOf(next));
                        break;
                    }
                    Rectangle r = table.getItem(table.getTopIndex()).getBounds();
                    next = table.getItem(new Point(r.x, r.y + table.getClientArea().height - 1));
                    if (next == null) {
                        next = table.getItem(count - 1);
                    }
                    if (next == null) break;
                    table.setTopIndex(table.indexOf(next));
                    break;
                }
                case 0x1000005: {
                    if (selItem == null) {
                        next = table.getItem(count - 1);
                        table.setTopIndex(table.indexOf(next));
                        break;
                    }
                    if (selIndex != table.getTopIndex()) {
                        next = table.getItem(table.getTopIndex());
                        break;
                    }
                    Rectangle r = table.getItem(table.getTopIndex()).getBounds();
                    int y = r.y + r.height - table.getClientArea().height + 1;
                    int i = selIndex - 1;
                    while (i >= 0) {
                        TableItem test = table.getItem(i);
                        if (test.getBounds().y <= y) {
                            next = test;
                            break;
                        }
                        --i;
                    }
                    if (next == null) {
                        next = table.getItem(0);
                    }
                    if (next == null) break;
                    table.setTopIndex(table.indexOf(next));
                }
            }
            if (next != null) {
                table.setSelection(next);
                Event selE = new Event();
                selE.type = 13;
                selE.item = next;
                selE.widget = table;
                Listener[] listenerArray = table.getListeners(13);
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener l = listenerArray[n2];
                    l.handleEvent(selE);
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static TreeItem getNextTreeRow(Tree tree, TreeItem item) {
        if (!item.getExpanded() || item.getItemCount() <= 0) ** GOTO lbl7
        return item.getItem(0);
lbl-1000:
        // 1 sources

        {
            i = parent.indexOf(item);
            if (i >= 0 && i + 1 < parent.getItemCount()) {
                return parent.getItem(i + 1);
            }
            item = parent;
lbl7:
            // 2 sources

            ** while ((parent = item.getParentItem()) != null)
        }
lbl8:
        // 1 sources

        i = tree.indexOf(item);
        if (i >= 0 && i + 1 < tree.getItemCount()) {
            return tree.getItem(i + 1);
        }
        return null;
    }

    public static TreeItem getPreviousTreeRow(Tree tree, TreeItem item) {
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            int i = parent.indexOf(item);
            if (i > 0) {
                TreeItem t = parent.getItem(i - 1);
                while (t.getExpanded() && t.getItemCount() > 0) {
                    t = t.getItem(t.getItemCount() - 1);
                }
                return t;
            }
            return parent;
        }
        int i = tree.indexOf(item);
        if (i > 0) {
            TreeItem t = tree.getItem(i - 1);
            while (t.getExpanded() && t.getItemCount() > 0) {
                t = t.getItem(t.getItemCount() - 1);
            }
            return t;
        }
        return null;
    }

    public static TreeItem getLastTreeRow(Tree tree) {
        if (tree.getItemCount() > 0) {
            TreeItem t = tree.getItem(tree.getItemCount() - 1);
            while (t.getExpanded() && t.getItemCount() > 0) {
                t = t.getItem(t.getItemCount() - 1);
            }
            return t;
        }
        return null;
    }

    public static void visitShellTreeRec(Shell shell, int modalities, int level, TreeMap<CompositeLong, Shell> out) {
        if (shell == null) {
            return;
        }
        if (!shell.isVisible()) {
            return;
        }
        if (RwtUtility.isPopupShell(shell)) {
            return;
        }
        int style = shell.getStyle();
        if (level == 0) {
            out.put(new CompositeLong(9L, (long)(-level)), shell);
        } else if ((style & 0x20000) != 0) {
            if ((modalities & 0x20000) != 0) {
                out.put(new CompositeLong(0L, (long)(-level)), shell);
            }
        } else if ((style & 0x10000) != 0) {
            if ((modalities & 0x10000) != 0) {
                out.put(new CompositeLong(1L, (long)(-level)), shell);
            }
        } else if (false) {
            out.put(new CompositeLong(2L, (long)(-level)), shell);
        }
        Shell[] children = shell.getShells();
        if (children != null) {
            Shell[] shellArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Shell child = shellArray[n2];
                RwtUtility.visitShellTreeRec(child, modalities, level + 1, out);
                ++n2;
            }
        }
    }

    public static String escapeMnemonics(String text) {
        if (StringUtility.isNullOrEmpty((String)text)) {
            return text;
        }
        return MNEMONIC_PATTERN.matcher(text).replaceAll("\\&$1");
    }

    @Deprecated
    public static void verifyUiInput(Control control) {
        RwtUtility.runUiInputVerifier(control);
    }

    public static void runUiInputVerifier() {
        Control focusControl = Display.getDefault().getFocusControl();
        RwtUtility.runUiInputVerifier(focusControl);
    }

    public static void runUiInputVerifier(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        IRwtScoutComposite compositeOnWidget = RwtScoutComposite.getCompositeOnWidget((Widget)control);
        if (compositeOnWidget instanceof RwtScoutComposite) {
            ((RwtScoutComposite)compositeOnWidget).runUiInputVerifier();
        }
    }

    public static String getKeyStrokePrettyPrinted(IAction scoutAction) {
        if (scoutAction == null) {
            return "";
        }
        return RwtUtility.getKeyStrokePrettyPrinted(scoutAction.getKeyStroke());
    }

    public static String getKeyStrokePrettyPrinted(String s) {
        if (!StringUtility.hasText((String)s)) {
            return "";
        }
        KeyStroke ks = new KeyStroke(s);
        int stateMask = RwtUtility.getRwtStateMask((IKeyStroke)ks);
        int keyCode = RwtUtility.getRwtKeyCode((IKeyStroke)ks);
        return LegacyActionTools.convertAccelerator((int)(stateMask | keyCode));
    }

    public static boolean isMarkupEnabled(Widget w) {
        return Boolean.TRUE.equals(w.getData("org.eclipse.rap.rwt.markupEnabled"));
    }
}

