/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;

public class LocalLogs
implements Logs {
    public static final LocalLogs NULL_LOGGER = new LocalLogs(){

        @Override
        public void addEntry(String logType, LogEntry entry) {
        }
    };
    private Map<String, List<LogEntry>> localLogs = new HashMap<String, List<LogEntry>>();
    private final Set<String> logTypesToIgnore;

    public LocalLogs() {
        this.logTypesToIgnore = ImmutableSet.of();
    }

    public LocalLogs(Set<String> logTypesToIgnore) {
        this.logTypesToIgnore = logTypesToIgnore;
    }

    @Override
    public LogEntries get(String logType) {
        return new LogEntries(this.getLocalLogs(logType));
    }

    private Iterable<LogEntry> getLocalLogs(String logType) {
        if (this.localLogs.containsKey(logType)) {
            return this.localLogs.get(logType);
        }
        return Lists.newArrayList();
    }

    public void addEntry(String logType, LogEntry entry) {
        if (this.logTypesToIgnore.contains(logType)) {
            return;
        }
        if (!this.localLogs.containsKey(logType)) {
            this.localLogs.put(logType, Lists.newArrayList((Object[])new LogEntry[]{entry}));
        } else {
            this.localLogs.get(logType).add(entry);
        }
    }
}

