/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class TriState
implements Serializable,
Comparable<TriState> {
    public static final TriState TRUE = new TriState(Boolean.TRUE);
    public static final TriState FALSE = new TriState(Boolean.FALSE);
    public static final TriState UNDEFINED = new TriState(null);
    private final Boolean value;
    private static final long serialVersionUID = 1L;

    public static TriState parseTriState(Object value) {
        if (value == null) {
            return UNDEFINED;
        }
        if (value instanceof TriState) {
            return (TriState)value;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return TRUE;
            }
            return FALSE;
        }
        if (value instanceof Number) {
            int i = ((Number)value).intValue();
            switch (i) {
                case 0: {
                    return FALSE;
                }
                case 1: {
                    return TRUE;
                }
            }
            return UNDEFINED;
        }
        if (value instanceof String) {
            if (value.equals("true")) {
                return TRUE;
            }
            if (value.equals("false")) {
                return FALSE;
            }
            if (value.equals("0")) {
                return FALSE;
            }
            if (value.equals("1")) {
                return TRUE;
            }
            return UNDEFINED;
        }
        throw new IllegalArgumentException("value of unknown type " + value + " [" + value.getClass() + "]");
    }

    private TriState(Boolean value) {
        this.value = value;
    }

    public Boolean getBooleanValue() {
        return this.value;
    }

    public Integer getIntegerValue() {
        return this.value != null ? Integer.valueOf(this.value != false ? 1 : 0) : null;
    }

    public boolean isTrue() {
        return this.value != null && this.value != false;
    }

    public boolean isFalse() {
        return this.value != null && this.value == false;
    }

    public boolean isUndefined() {
        return this.value == null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value != false ? "true" : "false";
        }
        return null;
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value != false ? 1 : 0;
        }
        return 2;
    }

    public boolean equals(Object obj) {
        if (this.value == obj) {
            return true;
        }
        if (obj instanceof TriState) {
            int b;
            int a;
            TriState t = (TriState)obj;
            int n = this.value != null ? (this.value.booleanValue() ? 1 : 0) : (a = 2);
            int n2 = t.value != null ? (t.value.booleanValue() ? 1 : 0) : (b = 2);
            return a == b;
        }
        return false;
    }

    @Override
    public int compareTo(TriState t) {
        Integer a = this.value != null ? (this.value.booleanValue() ? 1 : 0) : 2;
        Integer b = t.value != null ? (t.value.booleanValue() ? 1 : 0) : 2;
        return a.compareTo(b);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.value == null) {
            return UNDEFINED;
        }
        if (this.value.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }
}

