/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.html.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.html.IHtmlBind;
import org.eclipse.scout.commons.html.IHtmlContent;
import org.eclipse.scout.commons.html.internal.AbstractExpressionBuilder;

public class HtmlContentBuilder
extends AbstractExpressionBuilder
implements IHtmlContent {
    private final List<? extends IHtmlBind> m_texts;

    public HtmlContentBuilder(CharSequence ... texts) {
        this(Arrays.asList(texts));
    }

    public HtmlContentBuilder(List<? extends CharSequence> texts) {
        this.m_texts = this.importTexts(texts);
    }

    protected ArrayList<? extends IHtmlBind> importTexts(List<? extends CharSequence> texts) {
        ArrayList<IHtmlBind> bindTexts = new ArrayList<IHtmlBind>();
        for (CharSequence charSequence : texts) {
            if (charSequence == null) continue;
            if (charSequence instanceof IHtmlContent) {
                bindTexts.add(this.importHtml((IHtmlContent)charSequence));
                continue;
            }
            if (charSequence instanceof IHtmlBind) {
                bindTexts.add((IHtmlBind)charSequence);
                continue;
            }
            bindTexts.add(this.getBinds().put(charSequence));
        }
        return bindTexts;
    }

    @Override
    public void build() {
        if (this.m_texts.size() > 0) {
            this.appendText();
        }
    }

    protected void appendText() {
        for (CharSequence charSequence : this.m_texts) {
            this.append(charSequence);
        }
    }

    @Override
    public void replaceBinds(Map<String, String> bindMap) {
        super.replaceBinds(bindMap);
        for (IHtmlBind iHtmlBind : this.m_texts) {
            iHtmlBind.replaceBinds(bindMap);
        }
    }

    protected List<? extends IHtmlBind> getTexts() {
        return this.m_texts;
    }
}

