/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.transformation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class DeviceTransformationConfig {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DeviceTransformationConfig.class);
    private Set<IDeviceTransformation> m_enabledTransformations = new HashSet<IDeviceTransformation>();
    private Map<IForm, ExclusionInfo> m_excludedForms = new WeakHashMap<IForm, ExclusionInfo>();
    private Map<IFormField, ExclusionInfo> m_excludedFields = new WeakHashMap<IFormField, ExclusionInfo>();

    public void enableTransformation(IDeviceTransformation transformation) {
        this.m_enabledTransformations.add(transformation);
    }

    public void disableTransformation(IDeviceTransformation transformation) {
        this.m_enabledTransformations.remove(transformation);
    }

    public boolean isTransformationEnabled(IDeviceTransformation transformation) {
        return this.m_enabledTransformations.contains(transformation);
    }

    public boolean isTransformationEnabled(IDeviceTransformation transformation, IForm form) {
        if (!this.isTransformationEnabled(transformation)) {
            return false;
        }
        return !this.isFormTransformationExcluded(form, transformation);
    }

    public boolean isTransformationEnabled(IDeviceTransformation transformation, IFormField field) {
        if (!this.isTransformationEnabled(transformation)) {
            return false;
        }
        if (this.isFormTransformationExcluded(field.getForm(), transformation)) {
            return false;
        }
        return !this.isFieldTransformationExcluded(field, transformation);
    }

    public void excludeForm(IForm form) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.get(form);
        if (exclusionInfo == null) {
            exclusionInfo = new ExclusionInfo();
            this.m_excludedForms.put(form, exclusionInfo);
        }
        exclusionInfo.setExcludeAllTransformations(true);
        LOG.debug("Excluding form " + form);
    }

    public void excludeFormTransformation(IForm form, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.get(form);
        if (exclusionInfo == null) {
            exclusionInfo = new ExclusionInfo();
            this.m_excludedForms.put(form, exclusionInfo);
        }
        exclusionInfo.getExcludedTransformations().add(transformation);
        LOG.debug("Excluding form transformation " + transformation + " for form " + form);
    }

    public boolean isFormExcluded(IForm form) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.get(form);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations();
    }

    public boolean isFormTransformationExcluded(IForm form, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.get(form);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations() || exclusionInfo.getExcludedTransformations().contains(transformation);
    }

    public void excludeField(IFormField formField) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.get(formField);
        if (exclusionInfo == null) {
            exclusionInfo = new ExclusionInfo();
            this.m_excludedFields.put(formField, exclusionInfo);
        }
        exclusionInfo.setExcludeAllTransformations(true);
        LOG.debug("Excluding field " + formField);
    }

    public void excludeFieldTransformation(IFormField formField, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.get(formField);
        if (exclusionInfo == null) {
            exclusionInfo = new ExclusionInfo();
            this.m_excludedFields.put(formField, exclusionInfo);
        }
        exclusionInfo.getExcludedTransformations().add(transformation);
        LOG.debug("Excluding field transformation " + transformation + " for field " + formField);
    }

    public boolean isFieldExcluded(IFormField formField) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.get(formField);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations();
    }

    public boolean isFieldTransformationExcluded(IFormField formField, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.get(formField);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations() || exclusionInfo.getExcludedTransformations().contains(transformation);
    }

    private class ExclusionInfo {
        private boolean m_excludeAllTransformations = false;
        private Set<IDeviceTransformation> m_excludedTransformations = new HashSet<IDeviceTransformation>();

        public Set<IDeviceTransformation> getExcludedTransformations() {
            return this.m_excludedTransformations;
        }

        public boolean isExcludeAllTransformations() {
            return this.m_excludeAllTransformations;
        }

        public void setExcludeAllTransformations(boolean excludeAllTransformations) {
            this.m_excludeAllTransformations = excludeAllTransformations;
        }
    }
}

