/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table;

import java.io.InputStream;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.html.HTML;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.Activator;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.TEXTS;

public class PagingTableRow
extends TableRow {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PagingTableRow.class);
    private static String s_htmlCellTemplate;
    private Type m_type;

    static {
        try {
            s_htmlCellTemplate = PagingTableRow.initHtmlCellTemplate();
        }
        catch (Throwable e) {
            LOG.error("Couldn't load html template for page change cell.", e);
        }
    }

    public PagingTableRow(ColumnSet columnSet, Type type) {
        super(columnSet);
        this.m_type = type;
        this.updateContent(columnSet);
    }

    private void updateContent(ColumnSet columnSet) {
        IColumn column = (IColumn)CollectionUtility.firstElement((List)columnSet.getVisibleColumns());
        if (column != null) {
            String content = Type.back.equals((Object)this.m_type) ? TEXTS.get((String)"MobilePagingShowPrevious") : TEXTS.get((String)"MobilePagingShowNext");
            String output = s_htmlCellTemplate.replace("#CONTENT#", HTML.bold((CharSequence[])new CharSequence[]{content}).toEncodedHtml());
            this.getCellForUpdate(column).setText(output);
        }
    }

    private static String initHtmlCellTemplate() throws Throwable {
        return new String(IOUtility.getContent((InputStream)Activator.getDefault().getBundle().getResource("resources/html/MobileTableCellMoreElements.html").openStream()), "iso-8859-1");
    }

    public static enum Type {
        back,
        forward;

    }
}

