/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.test;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.BlockingCondition;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractSearchForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.osgi.framework.Bundle;

public final class ClientTestUtility {
    private ClientTestUtility() {
    }

    public static void sleep(int seconds) {
        if (seconds <= 0) {
            return;
        }
        final BlockingCondition bc = new BlockingCondition(true);
        new ClientSyncJob("sleep", ClientSyncJob.getCurrentSession()){

            @Override
            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                bc.release();
            }
        }.schedule(1000L * (long)seconds);
        try {
            bc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getNowAsString() {
        return "" + new Date();
    }

    public static Date getNowAsDate() {
        return new Date();
    }

    public static void searchEntityInOutline(AbstractPageWithTable<?> p, String formDataFieldId, long value) throws ProcessingException {
        AbstractSearchForm searchForm = (AbstractSearchForm)p.getSearchFormInternal();
        searchForm.rebuildSearchFilter();
        SearchFilter f = searchForm.getSearchFilter();
        f.clear();
        ((AbstractValueFieldData)f.getFormData().getFieldById(formDataFieldId)).setValue((Object)value);
        f.setCompleted(true);
        p.getSearchFormInternal().doReset();
        p.reloadPage();
    }

    public static void searchEntityInOutline(AbstractPageWithTable<?> p, String formDataFieldId, String value) throws ProcessingException {
        AbstractSearchForm searchForm = (AbstractSearchForm)p.getSearchFormInternal();
        searchForm.rebuildSearchFilter();
        SearchFilter f = searchForm.getSearchFilter();
        f.clear();
        ((AbstractValueFieldData)f.getFormData().getFieldById(formDataFieldId)).setValue((Object)value);
        f.setCompleted(true);
        p.getSearchFormInternal().doReset();
        p.reloadPage();
    }

    public static IClientSession getClientSession() {
        return ClientSyncJob.getCurrentSession();
    }

    public static Bundle getClientBundle() {
        return ClientSyncJob.getCurrentSession().getBundle();
    }

    public static IDesktop getDesktop() {
        return ClientSyncJob.getCurrentSession().getDesktop();
    }

    public static String getFormsPackage() {
        return String.valueOf(ClientTestUtility.getClientBundle().getSymbolicName()) + ".ui.forms";
    }

    public static IPage gotoOutline(Class<? extends AbstractOutline> outlineClass) {
        IPage rootPage = null;
        for (IOutline outline : ClientTestUtility.getDesktop().getAvailableOutlines()) {
            if (!outline.getClass().isAssignableFrom(outlineClass)) continue;
            ClientTestUtility.getDesktop().setOutline(outline);
            System.out.println("Selected Outline: " + outline.getTitle());
            outline.releaseUnusedPages();
            rootPage = outline.getRootPage();
        }
        return rootPage;
    }

    public static <T extends IPage> T gotoChildPage(IPage parentPage, Class<T> childPageClass) {
        IPage childPage = null;
        for (IPage page : parentPage.getChildPages()) {
            if (!childPageClass.isAssignableFrom(page.getClass())) continue;
            IOutline outline = ClientTestUtility.getDesktop().getOutline();
            outline.selectNode(page);
            System.out.println("Selected Page: " + page);
            outline.releaseUnusedPages();
            childPage = page;
        }
        return (T)childPage;
    }

    public static <T extends IPage> T gotoChildPage(Class<T> childPageClass) {
        IPage selectedNode = ClientTestUtility.getDesktop().getOutline().getActivePage();
        return ClientTestUtility.gotoChildPage(selectedNode, childPageClass);
    }

    public static void fillForm(AbstractForm form, long testNr) throws ProcessingException {
        for (IFormField formField : form.getAllFields()) {
            List rs;
            CodeLookupCall lookupCall;
            if (!formField.isEnabled() || !formField.isVisible() || !(formField instanceof AbstractValueField) || ((AbstractValueField)formField).getValue() != null) continue;
            if (formField instanceof AbstractStringField) {
                ((AbstractStringField)formField).setValue("test " + testNr);
                continue;
            }
            if (formField instanceof AbstractSmartField) {
                lookupCall = null;
                if (((AbstractSmartField)formField).getLookupCall() != null) {
                    lookupCall = ((AbstractSmartField)formField).getLookupCall();
                    ((AbstractSmartField)formField).prepareKeyLookup(lookupCall, null);
                    ((AbstractSmartField)formField).prepareTextLookup(lookupCall, "abc");
                    ((AbstractSmartField)formField).prepareBrowseLookup(lookupCall, "abc", TriState.TRUE);
                } else if (((AbstractSmartField)formField).getCodeTypeClass() != null) {
                    lookupCall = new CodeLookupCall(((AbstractSmartField)formField).getCodeTypeClass());
                }
                if (lookupCall == null) {
                    System.out.println("WARNING: Lookup Call for Field " + formField.getFieldId() + "is null!");
                    continue;
                }
                lookupCall.setActive(TriState.TRUE);
                lookupCall.setMaxRowCount(100);
                lookupCall.getDataByKey();
                lookupCall.getDataByText();
                rs = lookupCall.getDataByAll();
                if (rs.size() <= 0) continue;
                ((AbstractSmartField)formField).setValue(((ILookupRow)rs.get(0)).getKey());
                continue;
            }
            if (formField instanceof AbstractBigDecimalField) {
                ((AbstractBigDecimalField)formField).setValue(BigDecimal.valueOf(42.42));
                continue;
            }
            if (formField instanceof AbstractNumberField) {
                ((AbstractNumberField)formField).setValue(42L);
                continue;
            }
            if (formField instanceof AbstractDateField) {
                ((AbstractDateField)formField).setValue(new Date());
                continue;
            }
            if (!(formField instanceof AbstractListBox)) continue;
            lookupCall = null;
            if (((AbstractListBox)formField).getLookupCall() != null) {
                lookupCall = ((AbstractListBox)formField).getLookupCall();
                ((AbstractListBox)formField).prepareLookupCall(lookupCall);
            } else if (((AbstractListBox)formField).getCodeTypeClass() != null) {
                lookupCall = new CodeLookupCall(((AbstractListBox)formField).getCodeTypeClass());
            }
            if (lookupCall == null) {
                System.out.println("WARNING: Lookup Call for Field " + formField.getFieldId() + "is null!");
                continue;
            }
            lookupCall.setActive(TriState.TRUE);
            lookupCall.setMaxRowCount(100);
            lookupCall.getDataByKey();
            lookupCall.getDataByText();
            rs = lookupCall.getDataByAll();
            if (rs.size() <= 0 || ((AbstractListBox)formField).getCheckedKeyCount() != 0) continue;
            ((AbstractListBox)formField).checkKey(((ILookupRow)rs.get(0)).getKey());
        }
    }
}

