/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ICalendarContextMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class CalendarContextMenu
extends AbstractPropertyObserverContextMenu<ICalendar>
implements ICalendarContextMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CalendarContextMenu.class);

    public CalendarContextMenu(ICalendar owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(MenuUtility.getMenuTypesForCalendarSelection(((ICalendar)this.getOwner()).getSelectedComponent()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        if (this.getOwner() != null) {
            final CalendarComponent ownerValue = ((ICalendar)this.getOwner()).getSelectedComponent();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(ownerValue);
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                    }
                    return 1;
                }
            });
            this.setCurrentMenuTypes(MenuUtility.getMenuTypesForCalendarSelection(ownerValue));
            this.calculateLocalVisibility();
        }
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("selectedComponent".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }
}

