/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ICheckableTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

@Deprecated
public abstract class AbstractCheckableTable
extends AbstractTable
implements ICheckableTable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCheckableTable.class);
    private IBooleanColumn m_checkboxColumn;

    @Override
    protected boolean getConfiguredAutoResizeColumns() {
        return true;
    }

    @Override
    protected boolean getConfiguredMultiSelect() {
        return false;
    }

    @Override
    protected final boolean getConfiguredCheckable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredMultiCheckable() {
        return true;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMultiCheckable(this.getConfiguredMultiCheckable());
        for (IColumn<?> c : this.getColumns()) {
            if (c instanceof IBooleanColumn) {
                this.setCheckboxColumn((IBooleanColumn)c);
                break;
            }
            LOG.warn("could not find a check box column (column implements IBooleanColumn) in the checkable table.");
        }
    }

    public void setCheckboxColumn(IBooleanColumn checkboxColumn) {
        this.m_checkboxColumn = checkboxColumn;
    }

    @Override
    public IBooleanColumn getCheckboxColumn() {
        return this.m_checkboxColumn;
    }

    public boolean isMultiCheckable() {
        return this.propertySupport.getPropertyBool("multiCheckable");
    }

    public void setMultiCheckable(boolean on) {
        this.propertySupport.setPropertyBool("multiCheckable", on);
    }

    @Override
    protected void execRowClick(ITableRow row) throws ProcessingException {
        if (this.isEnabled() && row != null && this.getContextColumn() == this.getCheckboxColumn()) {
            Boolean oldValue = (Boolean)this.getCheckboxColumn().getValue(row);
            if (this.getCheckboxColumn() != null) {
                if (oldValue == null) {
                    oldValue = false;
                }
                this.checkRow(row, oldValue == false);
            }
        }
    }

    @Override
    public void checkRow(ITableRow row, Boolean value) throws ProcessingException {
        if (!row.isEnabled()) {
            return;
        }
        if (!this.isMultiCheckable() && value.booleanValue() && this.getCheckedRowCount() > 0) {
            this.uncheckAllRows();
        }
        this.getCheckboxColumn().setValue(row, value);
    }

    @Override
    public void checkRow(int row, Boolean value) throws ProcessingException {
        this.checkRow(this.getRow(row), value);
    }

    @Override
    public Collection<ITableRow> getCheckedRows() {
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>();
        boolean checked = false;
        int i = 0;
        while (i < this.getRowCount()) {
            boolean bl = checked = this.getCheckboxColumn().getValue(i) != null && (Boolean)this.getCheckboxColumn().getValue(i) != false;
            if (checked) {
                rows.add(this.getRow(i));
            }
            ++i;
        }
        return rows;
    }

    @Override
    public ITableRow getCheckedRow() {
        return (ITableRow)CollectionUtility.firstElement(this.getCheckedRows());
    }

    public int getCheckedRowCount() {
        return this.getCheckedRows().size();
    }

    @Override
    public void checkAllRows() {
        try {
            try {
                this.setTableChanging(true);
                int i = 0;
                while (i < this.getRowCount()) {
                    this.checkRow(i, Boolean.TRUE);
                    ++i;
                }
            }
            catch (ProcessingException e) {
                LOG.warn(null, (Throwable)e);
                this.setTableChanging(false);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void uncheckAllRows() {
        try {
            try {
                this.setTableChanging(true);
                int i = 0;
                while (i < this.getRowCount()) {
                    this.checkRow(i, Boolean.FALSE);
                    ++i;
                }
            }
            catch (ProcessingException e) {
                LOG.warn(null, (Throwable)e);
                this.setTableChanging(false);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Order(value=10.0)
    public class SpaceKeyStroke
    extends AbstractKeyStroke {
        @Override
        protected String getConfiguredKeyStroke() {
            return "space";
        }

        @Override
        protected void execAction() throws ProcessingException {
            if (AbstractCheckableTable.this.isEnabled()) {
                for (ITableRow row : AbstractCheckableTable.this.getSelectedRows()) {
                    Boolean b = (Boolean)AbstractCheckableTable.this.getCheckboxColumn().getValue(row);
                    if (b == null) {
                        b = false;
                    }
                    b = b == false;
                    AbstractCheckableTable.this.checkRow(row, b);
                }
            }
        }
    }
}

