/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.menus;

import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardService;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.SERVICES;

public class CopyWidthsOfColumnsMenu
extends AbstractMenu {
    public static final String COLUMN_COPY_CLIPBOARD_IDENTIFIER = "dev.table.menu.column.width.copy.ident";
    private final ITable m_table;

    public CopyWidthsOfColumnsMenu(ITable table) {
        this.m_table = table;
    }

    @Override
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"CopyWidthsOfColumnsMenu", (String[])new String[0]);
    }

    @Override
    protected boolean getConfiguredInheritAccessibility() {
        return false;
    }

    protected Set<IMenuType> getConfiguredMenuTypes() {
        return CollectionUtility.hashSet((Object)TableMenuType.Header);
    }

    @Override
    protected void execInitAction() throws ProcessingException {
        this.setVisible(Platform.inDevelopmentMode() && !UserAgentUtility.isWebClient());
    }

    @Override
    protected void execAction() {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(COLUMN_COPY_CLIPBOARD_IDENTIFIER);
            buf.append("\n");
            for (IColumn<?> column : this.getTable().getColumnSet().getVisibleColumns()) {
                buf.append(column.getClass().getName());
                buf.append("\t");
                buf.append(column.getWidth());
                buf.append("\n");
            }
            IClipboardService svc = (IClipboardService)SERVICES.getService(IClipboardService.class);
            svc.setTextContents(buf.toString());
        }
        catch (ProcessingException se) {
            se.addContextMessage(this.getText());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
        }
    }

    public ITable getTable() {
        return this.m_table;
    }
}

