/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal;

import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.IPageExtensionFilter;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.IPageModifier;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.AbstractPageExtension;

public class PageModificationExtension
extends AbstractPageExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PageModificationExtension.class);
    private final Class<? extends IPage> m_pageClass;
    private final Class<? extends IPageModifier<? extends IPage>> m_pageModifier;

    public PageModificationExtension(Class<? extends IPage> pageClass, Class<? extends IPageModifier<? extends IPage>> pageModifier) {
        this(null, pageClass, pageModifier);
    }

    public PageModificationExtension(IPageExtensionFilter pageFilter, Class<? extends IPage> pageClass, Class<? extends IPageModifier<? extends IPage>> pageModifier) {
        super(pageFilter);
        if (pageClass == null) {
            throw new IllegalArgumentException("pageClass must not be null");
        }
        if (pageModifier == null) {
            throw new IllegalArgumentException("pageModifier must not be null");
        }
        Class pageModifierPageType = TypeCastUtility.getGenericsParameterClass(pageModifier, IPageModifier.class);
        if (pageModifierPageType == null) {
            LOG.warn("could not determine generic type parameter of page modifier '" + pageModifier.getName() + ";");
        } else if (!pageModifierPageType.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("pageClass must be assignalbe to the generic type of given pageModifier. [pageClass: '" + pageClass.getName() + "', generic type on pageModifier: '" + pageModifierPageType.getName() + "'");
        }
        this.m_pageClass = pageClass;
        this.m_pageModifier = pageModifier;
    }

    public Class<? extends IPage> getPageClass() {
        return this.m_pageClass;
    }

    @Override
    public boolean accept(IOutline outline, IPage parentPage, IPage page) {
        if (!this.getPageClass().isInstance(page)) {
            return false;
        }
        return super.accept(outline, parentPage, page);
    }

    public <T extends IPage> IPageModifier<T> createPageModifier() throws ProcessingException {
        try {
            return this.m_pageModifier.newInstance();
        }
        catch (Exception e) {
            throw new ProcessingException("Error while instantiating page modifier '" + this.m_pageModifier + "'.", (Throwable)e);
        }
    }
}

