/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.diagnostic;

import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ServiceTunnelServlet;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticSession;
import org.eclipse.scout.rt.shared.ui.UserAgent;

public class DiagnosticServlet
extends ServiceTunnelServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            res.sendError(403);
            return;
        }
        Map<Class, Object> backup = ThreadContext.backup();
        try {
            try {
                this.lazyInit(req, res);
                ThreadContext.putHttpServletRequest(req);
                ThreadContext.putHttpServletResponse(res);
                UserAgent userAgent = UserAgent.createDefault();
                IServerSession serverSession = this.lookupScoutServerSessionOnHttpSession(req, res, subject, userAgent);
                DiagnosticServiceJob job = new DiagnosticServiceJob(serverSession, subject, req, res);
                job.runNow((IProgressMonitor)new NullProgressMonitor());
                job.throwOnError();
            }
            catch (ProcessingException e) {
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            ThreadContext.restore(backup);
        }
    }

    private class DiagnosticServiceJob
    extends ServerJob {
        protected HttpServletRequest m_request;
        protected HttpServletResponse m_response;

        public DiagnosticServiceJob(IServerSession serverSession, Subject subject, HttpServletRequest request, HttpServletResponse response) {
            super("DiagnosticServiceCall", serverSession, subject);
            this.m_request = request;
            this.m_response = response;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            String key;
            HttpSession session = this.m_request.getSession();
            DiagnosticSession ds = (DiagnosticSession)session.getAttribute(key = DiagnosticSession.class.getName());
            if (ds == null) {
                ds = new DiagnosticSession();
                session.setAttribute(key, (Object)ds);
            }
            ds.serviceRequest(this.m_request, this.m_response);
            return Status.OK_STATUS;
        }
    }
}

