/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form.properties;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.holders.IHolder;

public abstract class AbstractPropertyData<T>
implements IHolder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private T m_value;
    private boolean m_valueSet;

    public T getValue() {
        return this.m_value;
    }

    public void setValue(T o) {
        this.m_value = o;
        this.setValueSet(true);
    }

    public Class<T> getHolderType() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), IHolder.class);
    }

    public boolean isValueSet() {
        return this.m_valueSet;
    }

    public void setValueSet(boolean b) {
        this.m_valueSet = b;
    }

    public String getPropertyId() {
        String s = this.getClass().getSimpleName();
        if (s.endsWith("Property")) {
            s = s.replaceAll("Property$", "");
        }
        return s;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (!this.m_valueSet) {
            this.m_value = null;
        }
        if (this.m_value == null) {
            return;
        }
        if (!this.getHolderType().isAssignableFrom(this.m_value.getClass())) {
            throw new SecurityException("value is of inconsistent type; potential value corruption attack");
        }
    }
}

