/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.filechooserfield;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.filechooserfield.IRwtScoutFileDownloadField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutFileDownloadField
extends RwtScoutValueFieldComposite<IFileChooserField>
implements IRwtScoutFileDownloadField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutFileDownloadField.class);
    private Label m_dummyText;

    protected void initializeUi(Composite parent) {
        super.initializeUi(parent);
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_dummyText = this.getUiEnvironment().getFormToolkit().createLabel(container, "", 0);
        this.m_dummyText.setEnabled(false);
        this.setUiContainer(container);
        this.setUiLabel((ILabelComposite)label);
        this.setUiField((Control)this.m_dummyText);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    public Label getUiField() {
        return (Label)super.getUiField();
    }

    protected void setValueFromScout() {
        File f = ((IFileChooserField)this.getScoutObject()).getValueAsFile();
        if (f != null) {
            String name = f.getName();
            if (name.endsWith(".tmp")) {
                this.m_dummyText.setText("(" + TEXTS.get((String)"Automatic") + ")");
            } else {
                this.m_dummyText.setText(name);
            }
        } else {
            this.m_dummyText.setText("");
        }
    }

    protected void attachScout() {
        super.attachScout();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    IFileChooser chooser = ((IFileChooserField)RwtScoutFileDownloadField.this.getScoutObject()).getFileChooser();
                    String fileName = chooser.getFileName();
                    if (fileName == null) {
                        List exts = ((IFileChooserField)RwtScoutFileDownloadField.this.getScoutObject()).getFileExtensions();
                        fileName = "download." + (CollectionUtility.hasElements((Collection)exts) ? (String)CollectionUtility.firstElement((List)exts) : "tmp");
                    }
                    File tempFile = new File(IOUtility.createTempDirectory((String)"download"), fileName);
                    tempFile.deleteOnExit();
                    ((IFileChooserField)RwtScoutFileDownloadField.this.getScoutObject()).getUIFacade().setTextFromUI(tempFile.getAbsolutePath());
                }
                catch (Exception e) {
                    LOG.error("Failed creating temporary file for " + ((IFileChooserField)RwtScoutFileDownloadField.this.getScoutObject()).getClass(), (Throwable)e);
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }
}

