/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.filechooser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.window.filechooser.IRwtScoutFileChooser;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class RwtScoutFileChooser
implements IRwtScoutFileChooser {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutFileChooser.class);
    private final IFileChooser m_scoutFileChooser;
    private final Shell m_parentShell;

    public RwtScoutFileChooser(Shell parentShell, IFileChooser fileChooser) {
        this.m_parentShell = parentShell;
        this.m_scoutFileChooser = fileChooser;
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.m_parentShell.getDisplay().getData(IRwtEnvironment.class.getName());
    }

    public void showFileChooser() {
        List<Object> files = null;
        try {
            if (this.getScoutFileChooser().isFolderMode()) {
                LOG.error("IFileChooserField.isFolderMode() == true is not possible in RAP");
                files = CollectionUtility.emptyArrayList();
            } else if (!this.getScoutFileChooser().isTypeLoad()) {
                LOG.info("IFileChooserField.isTypeLoad() == false (SAVE) is not possible in RAP, doing nothing");
                files = CollectionUtility.emptyArrayList();
            } else {
                files = this.uploadFiles();
            }
        }
        catch (Throwable throwable) {
            ArrayList finalFiles = files;
            Runnable job = new Runnable(finalFiles){
                private final /* synthetic */ List val$finalFiles;
                {
                    this.val$finalFiles = list;
                }

                @Override
                public void run() {
                    RwtScoutFileChooser.this.m_scoutFileChooser.setFiles(this.val$finalFiles);
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 0L);
            throw throwable;
        }
        ArrayList finalFiles = files;
        Runnable job = new /* invalid duplicate definition of identical inner class */;
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    protected List<File> uploadFiles() {
        int style = 0;
        style = this.getScoutFileChooser().isTypeLoad() ? (style |= 0x1000) : (style |= 0x2000);
        if (this.getScoutFileChooser().isMultiSelect()) {
            style |= 2;
        }
        if (this.getScoutFileChooser().getFileExtensions() != null) {
            LOG.info("Setting file extensions using IFileChooserField.getFileExtensions() is currently not possible in RAP. Operation is ignored.");
        }
        FileDialog dialog = new FileDialog(this.getParentShell(), style);
        if (this.getScoutFileChooser().getDirectory() != null) {
            LOG.info("Setting filter path using IFileChooserField.getDirectory() is currently not possible in RAP. Operation is ignored.");
        }
        if (this.getScoutFileChooser().getFileName() != null) {
            LOG.info("Setting file name using IFileChooserField.getFileName() is currently possible in RAP. Operation is ignored.");
        }
        this.setFileDialogTitle(dialog, this.getScoutFileChooser().isMultiSelect());
        dialog.open();
        String[] selectedFiles = dialog.getFileNames();
        if (selectedFiles != null && selectedFiles.length > 0) {
            ArrayList<File> files = new ArrayList<File>(selectedFiles.length);
            String[] stringArray = selectedFiles;
            int n = selectedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String selectedFile = stringArray[n2];
                files.add(new File(selectedFile));
                ++n2;
            }
            return files;
        }
        return CollectionUtility.emptyArrayList();
    }

    private void setFileDialogTitle(FileDialog fileDialog, boolean isMultiselect) {
        if (isMultiselect) {
            fileDialog.setText(ScoutTexts.get((String)"FileChooserRAPMultipleFiles", (String[])new String[0]));
        } else {
            fileDialog.setText(ScoutTexts.get((String)"FileChooserRAPSingleFile", (String[])new String[0]));
        }
    }

    public IFileChooser getScoutFileChooser() {
        return this.m_scoutFileChooser;
    }

    public Shell getParentShell() {
        return this.m_parentShell;
    }
}

