/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutHtmlValidator;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.html.HtmlAdapter;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.IRwtScoutListModel;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtScoutList;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

public class RwtScoutListModel
implements IRwtScoutListModel {
    private static final long serialVersionUID = 1L;
    public static final String HYPERLINK_ROW_PARAM = "1row1Num1";
    private transient ListenerList listenerList = null;
    private final ITable m_scoutTable;
    private final RwtScoutList m_uiList;
    private boolean m_multiline;
    private final IRwtEnvironment m_env;

    public RwtScoutListModel(ITable scoutTable, RwtScoutList uiTable) {
        this.m_scoutTable = scoutTable;
        this.m_uiList = uiTable;
        this.m_env = uiTable.getUiEnvironment();
    }

    @Override
    public void setMultiline(boolean multiline) {
        this.m_multiline = multiline;
    }

    @Override
    public boolean isMultiline() {
        return this.m_multiline;
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_scoutTable != null) {
            return this.m_scoutTable.getFilteredRows().toArray();
        }
        return new Object[0];
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    private Object[] getListeners() {
        ListenerList list = this.listenerList;
        if (list == null) {
            return new Object[0];
        }
        return list.getListeners();
    }

    public void dispose() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void consumeTableModelEvent(RwtScoutTableEvent uiTableEvent) {
    }

    protected ICell getCell(Object row) {
        IColumn column = (IColumn)CollectionUtility.firstElement((List)this.m_scoutTable.getColumnSet().getVisibleColumns());
        if (column != null) {
            ITableRow tableRow = (ITableRow)row;
            return tableRow.getCell(column);
        }
        return null;
    }

    @Override
    public RwtScoutList getUiList() {
        return this.m_uiList;
    }

    public ITable getScoutTable() {
        return this.m_scoutTable;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        ICell cell = this.getCell(element);
        if (cell == null) {
            return "";
        }
        String text = StringUtility.nvl((Object)cell.getText(), (String)"");
        if (HtmlTextUtility.isTextWithHtmlMarkup((String)text)) {
            HtmlAdapter htmlAdapter = this.m_uiList.getUiEnvironment().getHtmlAdapter();
            text = htmlAdapter.adaptHtmlCell((IRwtScoutComposite)this.m_uiList, text);
            HashMap<String, String> params = new HashMap<String, String>();
            ITableRow tableRow = (ITableRow)element;
            params.put(HYPERLINK_ROW_PARAM, String.valueOf(tableRow.getRowIndex()));
            text = htmlAdapter.convertLinksInHtmlCell((IRwtScoutComposite)this.m_uiList, text, params);
        } else {
            boolean multiline = false;
            if (text.indexOf("\n") >= 0 && !(multiline = this.isMultiline())) {
                text = StringUtility.replaceNewLines((String)text, (String)" ");
            }
            if (cell.isHtmlEnabled() && (RwtUtility.isMarkupEnabled((Widget)this.getUiList().getUiField()) || multiline)) {
                return HtmlTextUtility.transformPlainTextToHtml((String)text);
            }
        }
        return HtmlTextUtility.validateHtmlCapableText((IRwtScoutHtmlValidator)this.m_env.getHtmlValidator(), (Object)cell, (String)text);
    }
}

