/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.workbench;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.AbstractRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.WidgetPrinter;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.workbench.IRwtWorkbenchEnvironment;
import org.eclipse.scout.rt.ui.rap.workbench.window.editor.AbstractScoutEditorPart;
import org.eclipse.scout.rt.ui.rap.workbench.window.editor.ScoutFormEditorInput;
import org.eclipse.scout.rt.ui.rap.workbench.window.view.AbstractScoutView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.osgi.framework.Bundle;

@Deprecated
public abstract class AbstractRwtWorkbenchEnvironment
extends AbstractRwtEnvironment
implements IRwtWorkbenchEnvironment {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRwtWorkbenchEnvironment.class);
    private Display m_display;
    private HashMap<String, String> m_scoutPartIdToUiPartId;
    private Map<String, List<IForm>> m_openLaterMap = new HashMap<String, List<IForm>>();
    private OptimisticLock m_activateViewLock;
    private P_PerspectiveListener m_perspectiveListener;
    private final String m_perspectiveId;

    public AbstractRwtWorkbenchEnvironment(Bundle applicationBundle, Class<? extends IClientSession> clientSessionClazz, String perspectiveId) {
        super(applicationBundle, clientSessionClazz);
        this.m_perspectiveId = perspectiveId;
        this.m_scoutPartIdToUiPartId = new HashMap();
        this.m_activateViewLock = new OptimisticLock();
    }

    protected void attachUiListeners() {
        if (this.m_perspectiveListener == null) {
            this.m_perspectiveListener = new P_PerspectiveListener();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.m_perspectiveListener);
        }
    }

    protected void detachUiListeners() {
        if (this.m_perspectiveListener != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.m_perspectiveListener);
            this.m_perspectiveListener = null;
        }
    }

    @Override
    public boolean acquireActivateViewLock() {
        return this.m_activateViewLock.acquire();
    }

    public boolean isActivateViewLockAcquired() {
        return this.m_activateViewLock.isAcquired();
    }

    @Override
    public void releaseActivateViewLock() {
        this.m_activateViewLock.release();
    }

    protected synchronized void init(Runnable additionalInitCallback) throws CoreException {
        if (this.getSubject() == null) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                throw new SecurityException("/rap request is not authenticated with a Subject");
            }
            this.setSubject(subject);
        }
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            throw new IllegalStateException("workbench must be active");
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = workbenchPage.getViewReferences();
                int n5 = iViewReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IViewReference viewReference = iViewReferenceArray[n6];
                    if (this.m_scoutPartIdToUiPartId.containsValue(viewReference.getId()) && workbenchPage.isPartVisible(viewReference.getPart(false))) {
                        workbenchPage.hideView(viewReference);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        super.init(additionalInitCallback);
        this.attachUiListeners();
    }

    protected void dispose() {
        super.dispose();
        this.detachUiListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showFormPart(IForm form) {
        if (form == null) {
            return;
        }
        if (form.getDisplayHint() != 20) {
            super.showFormPart(form);
            return;
        }
        String scoutViewId = form.getDisplayViewId();
        String uiViewId = this.getUiPartIdForScoutPartId(scoutViewId);
        if (uiViewId == null) {
            LOG.warn("no view defined for scoutViewId: " + form.getDisplayViewId());
            return;
        }
        IViewPart existingView = this.findViewPart(uiViewId);
        String formPerspectiveId = form.getPerspectiveId();
        if (formPerspectiveId == null) {
            formPerspectiveId = "";
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (StringUtility.hasText((String)formPerspectiveId) && existingView == null && activePage != null && CompareUtility.notEquals((Object)activePage.getPerspective().getId(), (Object)formPerspectiveId)) {
            Map<String, List<IForm>> map = this.m_openLaterMap;
            synchronized (map) {
                if (!this.m_openLaterMap.containsKey(formPerspectiveId) || !this.m_openLaterMap.get(formPerspectiveId).contains(form)) {
                    if (this.m_openLaterMap.get(formPerspectiveId) == null) {
                        this.m_openLaterMap.put(formPerspectiveId, new ArrayList());
                    }
                    this.m_openLaterMap.get(formPerspectiveId).add(form);
                }
            }
            return;
        }
        if ("EDITOR".equals(form.getDisplayViewId()) || "EDITOR".equals(form.getDisplayViewId())) {
            if (activePage != null) {
                ScoutFormEditorInput editorInput = new ScoutFormEditorInput(form, this);
                AbstractScoutEditorPart editor = this.getEditorPart(editorInput, uiViewId);
                this.putPart(form, editor);
            }
        } else {
            AbstractScoutView view = this.getViewPart(uiViewId);
            view.showForm(form);
            this.putPart(form, view);
        }
    }

    public Display getDisplay() {
        if (this.m_display == null) {
            this.m_display = Display.getDefault();
            if (this.m_display == null) {
                this.m_display = new Display();
            }
        }
        return this.m_display;
    }

    public void registerPart(String scoutPartLocation, String uiPartId) {
        this.m_scoutPartIdToUiPartId.put(scoutPartLocation, uiPartId);
    }

    public void unregisterPart(String scoutPartLocation) {
        this.m_scoutPartIdToUiPartId.remove(scoutPartLocation);
    }

    public final String[] getAllPartIds() {
        HashSet<String> partIds = new HashSet<String>(this.m_scoutPartIdToUiPartId.values());
        return partIds.toArray(new String[partIds.size()]);
    }

    public final String getUiPartIdForScoutPartId(String scoutPartLocation) {
        return this.m_scoutPartIdToUiPartId.get(scoutPartLocation);
    }

    public final String getScoutPartIdForUiPartId(String partId) {
        if (partId == null) {
            return "";
        }
        for (Map.Entry<String, String> entry : this.m_scoutPartIdToUiPartId.entrySet()) {
            if (!entry.getValue().equals(partId)) continue;
            return entry.getKey();
        }
        return "";
    }

    public IViewPart findViewPart(String viewId) {
        IViewDescriptor viewRef;
        if (viewId != null && (viewRef = PlatformUI.getWorkbench().getViewRegistry().find(viewId)) != null && !viewRef.getAllowMultiple()) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewId);
        }
        return null;
    }

    public AbstractScoutEditorPart getEditorPart(IEditorInput editorInput, String editorId) {
        if (editorInput != null && editorId != null) {
            try {
                IEditorPart editor = null;
                editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor(editorInput);
                if (editor == null) {
                    editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, editorId);
                }
                if (editor instanceof AbstractScoutEditorPart) {
                    return (AbstractScoutEditorPart)editor;
                }
                LOG.warn("editors used in scout's enviromnent must be extensions of AbstractScoutEditorPart");
            }
            catch (PartInitException e) {
                LOG.error("could not inizialize editor", (Throwable)e);
            }
        }
        return null;
    }

    public AbstractScoutView getViewPart(String viewId) {
        if (viewId != null) {
            String secondaryId = null;
            IViewDescriptor viewRef = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
            if (viewRef.getAllowMultiple()) {
                secondaryId = "" + System.currentTimeMillis();
            }
            try {
                IViewPart view = null;
                if (secondaryId == null) {
                    view = this.findViewPart(viewId);
                    if (view == null) {
                        view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
                    }
                } else {
                    view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId, secondaryId, 1);
                }
                if (view instanceof AbstractScoutView) {
                    return (AbstractScoutView)view;
                }
                LOG.warn("views used in scout's enviromnent must be extensions of AbstractScoutView");
            }
            catch (PartInitException e) {
                LOG.error("could not inizialize view", (Throwable)e);
            }
        }
        return null;
    }

    protected void fireGuiDetachedFromUIInternal() {
        super.fireGuiDetachedFromUIInternal();
        if (this.getDisplay() != null && !this.getDisplay().isDisposed()) {
            this.getDisplay().asyncExec((Runnable)new P_HideScoutViews());
        }
    }

    protected void fireDesktopActivatedFromUIInternal() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().ensureViewStackVisible();
        }
    }

    public Shell getParentShellIgnoringPopups(int modalities) {
        Shell shell = Display.getCurrent().getActiveShell();
        if (shell == null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (shell != null) {
            while (RwtUtility.isPopupShell((Shell)shell) && shell.getParent() instanceof Shell) {
                shell = (Shell)shell.getParent();
            }
        }
        if (shell == null) {
            TreeMap map = new TreeMap();
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow w = iWorkbenchWindowArray[n2];
                RwtUtility.visitShellTreeRec((Shell)w.getShell(), (int)modalities, (int)0, map);
                ++n2;
            }
            if (map.size() > 0) {
                shell = (Shell)map.get(map.firstKey());
            }
        }
        if (shell != null && shell.getData() instanceof ProgressMonitorDialog) {
            shell = (Shell)shell.getParent();
        }
        return shell;
    }

    private synchronized boolean handlePerspectiveOpened(String perspectiveId) {
        if (this.m_perspectiveId.equals(perspectiveId)) {
            if (!this.isStartDesktopCalled()) {
                P_PerspecitveOpenedJob j = new P_PerspecitveOpenedJob(this.getDesktopOpenedTaskText(), this.getClientSession());
                j.schedule();
                this.setStartDesktopCalled(true);
            }
            this.getKeyStrokeManager().setGlobalKeyStrokesActivated(true);
            return this.isStartDesktopCalled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean handlePerspectiveActivated(String perspectiveId) {
        if (this.m_openLaterMap.containsKey(perspectiveId)) {
            List<IForm> list;
            Map<String, List<IForm>> map = this.m_openLaterMap;
            synchronized (map) {
                list = this.m_openLaterMap.remove(perspectiveId);
            }
            for (IForm form : list) {
                this.showFormPart(form);
            }
            this.setActivateDesktopCalled(CompareUtility.notEquals((Object)this.m_perspectiveId, (Object)perspectiveId));
        }
        if (this.m_perspectiveId.equals(perspectiveId) && this.isStartDesktopCalled()) {
            if (!this.isActivateDesktopCalled()) {
                P_PerspectiveActivatedJob j = new P_PerspectiveActivatedJob(this.getDesktopOpenedTaskText(), this.getClientSession());
                j.schedule();
                this.setActivateDesktopCalled(true);
            }
            this.getKeyStrokeManager().setGlobalKeyStrokesActivated(true);
            return this.isActivateDesktopCalled();
        }
        return false;
    }

    private synchronized boolean handlePerspectiveClosed(String perspectiveId) {
        boolean called = false;
        if (this.m_perspectiveId.equals(perspectiveId)) {
            P_PerspectiveClosedJob j = new P_PerspectiveClosedJob(this.getDesktopClosedTaskText(), this.getClientSession());
            j.schedule();
            called = true;
            this.setStartDesktopCalled(false);
            this.setActivateDesktopCalled(false);
            this.getKeyStrokeManager().setGlobalKeyStrokesActivated(false);
        }
        return called;
    }

    protected void handleScoutPrintInRwt(DesktopEvent e) {
        WidgetPrinter wp = new WidgetPrinter((Control)this.getParentShellIgnoringPopups(196608));
        try {
            wp.print(e.getPrintDevice(), e.getPrintParameters());
        }
        catch (Throwable ex) {
            LOG.error(null, ex);
        }
    }

    private class P_HideScoutViews
    implements Runnable {
        private P_HideScoutViews() {
        }

        @Override
        public void run() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewReference = iViewReferenceArray[n2];
                    IViewPart view = viewReference.getView(false);
                    if (view != null && view instanceof AbstractScoutView) {
                        if (((AbstractScoutView)view).getScoutObject() == null) {
                            activePage.hideView(viewReference);
                        }
                    } else if (AbstractRwtWorkbenchEnvironment.this.m_scoutPartIdToUiPartId.containsValue(viewReference.getId())) {
                        activePage.hideView(viewReference);
                    }
                    ++n2;
                }
            }
        }
    }

    private final class P_PerspecitveOpenedJob
    extends ClientAsyncJob {
        public P_PerspecitveOpenedJob(String name, IClientSession session) {
            super(name, session);
        }

        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            AbstractRwtWorkbenchEnvironment.this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractRwtWorkbenchEnvironment.this.applyScoutState();
                }
            });
            ClientSyncJob clienSyncJob = new ClientSyncJob(AbstractRwtWorkbenchEnvironment.this.getDesktopOpenedTaskText(), this.getClientSession()){

                protected void runVoid(IProgressMonitor syncMonitor) throws Throwable {
                    AbstractRwtWorkbenchEnvironment.this.fireGuiAttachedFromUIInternal();
                }
            };
            clienSyncJob.schedule();
        }
    }

    private final class P_PerspectiveActivatedJob
    extends ClientAsyncJob {
        public P_PerspectiveActivatedJob(String name, IClientSession session) {
            super(name, session);
        }

        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            ClientSyncJob clienSyncJob = new ClientSyncJob(AbstractRwtWorkbenchEnvironment.this.getDesktopOpenedTaskText(), this.getClientSession()){

                protected void runVoid(IProgressMonitor syncMonitor) throws Throwable {
                    AbstractRwtWorkbenchEnvironment.this.fireDesktopActivatedFromUIInternal();
                }
            };
            clienSyncJob.schedule();
        }
    }

    private final class P_PerspectiveClosedJob
    extends ClientAsyncJob {
        public P_PerspectiveClosedJob(String name, IClientSession session) {
            super(name, session);
        }

        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            ClientSyncJob clienSyncJob = new ClientSyncJob(AbstractRwtWorkbenchEnvironment.this.getDesktopOpenedTaskText(), this.getClientSession()){

                protected void runVoid(IProgressMonitor syncMonitor) throws Throwable {
                    AbstractRwtWorkbenchEnvironment.this.fireGuiDetachedFromUIInternal();
                }
            };
            clienSyncJob.schedule();
        }
    }

    private class P_PerspectiveListener
    extends PerspectiveAdapter {
        private P_PerspectiveListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            String perspectiveId = perspective.getId();
            if (AbstractRwtWorkbenchEnvironment.this.handlePerspectiveOpened(perspectiveId)) {
                AbstractRwtWorkbenchEnvironment.this.handlePerspectiveActivated(perspectiveId);
            }
        }

        public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (AbstractRwtWorkbenchEnvironment.this.m_perspectiveId.equals(perspective.getId())) {
                AbstractRwtWorkbenchEnvironment.this.getKeyStrokeManager().setGlobalKeyStrokesActivated(false);
            }
        }

        public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            AbstractRwtWorkbenchEnvironment.this.handlePerspectiveClosed(perspective.getId());
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            String perspectiveId = perspective.getId();
            if ("reset".equals(changeId)) {
                AbstractRwtWorkbenchEnvironment.this.handlePerspectiveClosed(perspectiveId);
            } else if ("resetComplete".equals(changeId) && AbstractRwtWorkbenchEnvironment.this.handlePerspectiveOpened(perspectiveId)) {
                AbstractRwtWorkbenchEnvironment.this.handlePerspectiveActivated(perspectiveId);
            }
        }
    }
}

