/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.workbench.window.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.util.ScoutFormToolkit;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.workbench.util.listener.PartListener;
import org.eclipse.scout.rt.ui.rap.workbench.window.editor.ScoutFormEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.part.EditorPart;

@Deprecated
public abstract class AbstractScoutEditorPart
extends EditorPart
implements IRwtScoutPart,
ISaveablePart2 {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractScoutEditorPart.class);
    public static final String EDITOR_ID = AbstractScoutEditorPart.class.getName();
    private final IRwtEnvironment m_uiEnvironment = this.createUiEnvironment();
    private Form m_rootForm;
    private Composite m_rootArea;
    private P_EditorListener m_editorListener;
    private OptimisticLock m_closeLock;
    private OptimisticLock m_closeFromModel = new OptimisticLock();
    private PropertyChangeListener m_formPropertyListener;
    private OptimisticLock m_layoutLock = new OptimisticLock();

    public AbstractScoutEditorPart() {
        this.m_closeLock = new OptimisticLock();
        this.m_formPropertyListener = new P_ScoutPropertyChangeListener();
    }

    public void setBusy(boolean b) {
    }

    protected void attachScout() {
        IForm form = this.getScoutObject();
        this.setTitleFromScout(form.getTitle());
        this.setImageFromScout(form.getIconId());
        this.setMaximizeEnabledFromScout(form.isMaximizeEnabled());
        this.setMaximizedFromScout(form.isMaximized());
        this.setMinimizeEnabledFromScout(form.isMinimizeEnabled());
        this.setMinimizedFromScout(form.isMinimized());
        boolean closable = false;
        for (IFormField f : form.getAllFields()) {
            if (f.isEnabled() && f.isVisible() && f instanceof IButton) {
                switch (((IButton)f).getSystemType()) {
                    case 1: 
                    case 2: {
                        closable = true;
                    }
                }
            }
            if (closable) break;
        }
        this.setCloseEnabledFromScout(closable);
        form.addPropertyChangeListener(this.m_formPropertyListener);
        if (this.m_editorListener == null) {
            this.m_editorListener = new P_EditorListener();
        }
        this.getSite().getPage().addPartListener((IPartListener2)this.m_editorListener);
    }

    protected void detachScout() {
        if (this.getScoutObject() != null) {
            this.getScoutObject().removePropertyChangeListener(this.m_formPropertyListener);
        }
    }

    public void showPart() {
    }

    public void closePart() {
        try {
            this.m_closeFromModel.acquire();
            if (this.m_closeLock.acquire()) {
                try {
                    this.getSite().getPage().closeEditor((IEditorPart)this, false);
                }
                catch (Exception e) {
                    LOG.error("could not close editor '" + this.getEditorSite().getId() + "'.", (Throwable)e);
                }
            }
        }
        finally {
            this.m_closeLock.release();
            this.m_closeFromModel.release();
        }
    }

    public void dispose() {
        this.detachScout();
        this.getSite().getPage().removePartListener((IPartListener2)this.m_editorListener);
        super.dispose();
    }

    protected void setImageFromScout(String iconId) {
        Image img = this.getUiEnvironment().getIcon(iconId);
        this.setTitleImage(img);
        String sub = this.getScoutObject().getSubTitle();
        if (sub != null) {
            this.getUiForm().setImage(img);
        } else {
            this.getUiForm().setImage(null);
        }
    }

    protected void setTitleFromScout(String title) {
        IForm f = this.getScoutObject();
        String s = f.getBasicTitle();
        this.setPartName(StringUtility.removeNewLines((String)(s != null ? s : "")));
        s = f.getSubTitle();
        if (s != null) {
            this.getUiForm().setText(RwtUtility.escapeMnemonics((String)StringUtility.removeNewLines((String)(s != null ? s : ""))));
        } else {
            this.getUiForm().setText(null);
        }
    }

    protected void setMaximizeEnabledFromScout(boolean maximizable) {
    }

    protected void setMaximizedFromScout(boolean maximized) {
    }

    protected void setMinimizeEnabledFromScout(boolean minized) {
    }

    protected void setMinimizedFromScout(boolean minimized) {
    }

    private void setSaveNeededFromScout() {
        this.firePropertyChange(257);
    }

    protected void setCloseEnabledFromScout(boolean closebale) {
    }

    protected abstract IRwtEnvironment createUiEnvironment();

    public final IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    public void createPartControl(Composite parent) {
        ScoutFormToolkit toolkit = this.getUiEnvironment().getFormToolkit();
        this.m_rootForm = toolkit.createForm(parent);
        this.m_rootArea = this.m_rootForm.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.verticalSpacing = 0;
        this.m_rootArea.setLayout((Layout)gridLayout);
        try {
            this.m_layoutLock.acquire();
            this.m_rootArea.setRedraw(false);
            IRwtScoutForm form = this.getUiEnvironment().createForm(this.m_rootArea, this.getScoutObject());
            GridData d = new GridData(1808);
            form.getUiContainer().setLayoutData((Object)d);
            this.attachScout();
        }
        finally {
            this.m_layoutLock.release();
            this.m_rootArea.setRedraw(true);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ScoutFormEditorInput)) {
            throw new PartInitException("Input must be from instance ScoutFormEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public IForm getScoutObject() {
        return ((ScoutFormEditorInput)this.getEditorInput()).getScoutObject();
    }

    public Form getUiForm() {
        return this.getRootForm();
    }

    public Composite getUiContainer() {
        return this.getUiForm();
    }

    protected Form getRootForm() {
        return this.m_rootForm;
    }

    public int promptToSaveOnClose() {
        if (this.getScoutObject() == null) {
            return 1;
        }
        if (this.m_closeFromModel.isReleased()) {
            new ClientSyncJob("Prompt to save", this.getUiEnvironment().getClientSession()){

                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    AbstractScoutEditorPart.this.getScoutObject().getUIFacade().fireFormClosingFromUI();
                }
            }.schedule();
            return 2;
        }
        return 0;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        if (this.getScoutObject() != null && this.getScoutObject().isAskIfNeedSave()) {
            return this.getScoutObject().isSaveNeeded();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public void setFocus() {
        this.m_rootArea.setFocus();
    }

    protected void handlePartActivatedFromUI() {
        if (this.getUiEnvironment().isInitialized()) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    if (AbstractScoutEditorPart.this.getScoutObject() != null) {
                        AbstractScoutEditorPart.this.getScoutObject().getUIFacade().fireFormActivatedFromUI();
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 0L);
        }
    }

    protected void handleClosedFromUI() {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                try {
                    if (AbstractScoutEditorPart.this.m_closeLock.acquire() && AbstractScoutEditorPart.this.getScoutObject() != null) {
                        AbstractScoutEditorPart.this.getScoutObject().getUIFacade().fireFormKilledFromUI();
                    }
                }
                finally {
                    AbstractScoutEditorPart.this.m_closeLock.release();
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    public void activate() {
        this.getSite().getPage().activate(this.getSite().getPart());
    }

    public boolean isActive() {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return false;
        }
        IWorkbenchPage activePage = w.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage == this.getSite().getPage() && activePage.getActivePart() == this;
    }

    public boolean isVisible() {
        return this.getSite().getPage().isPartVisible(this.getSite().getPart());
    }

    public boolean setStatusLineMessage(Image image, String message) {
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(image, message);
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("title")) {
            this.setTitleFromScout((String)newValue);
        } else if (name.equals("iconId")) {
            this.setImageFromScout((String)newValue);
        } else if (name.equals("minimizeEnabled")) {
            this.setMinimizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("maximizeEnabled")) {
            this.setMaximizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("minimized")) {
            this.setMinimizedFromScout((Boolean)newValue);
        } else if (name.equals("maximized")) {
            this.setMaximizedFromScout((Boolean)newValue);
        } else if (name.equals("saveNeeded")) {
            this.setSaveNeededFromScout();
        }
    }

    private class P_EditorListener
    extends PartListener {
        private P_EditorListener() {
        }

        @Override
        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && part.equals(AbstractScoutEditorPart.this.getEditorSite().getPart())) {
                AbstractScoutEditorPart.this.handleClosedFromUI();
            }
        }

        @Override
        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false).equals(AbstractScoutEditorPart.this.getEditorSite().getPart())) {
                AbstractScoutEditorPart.this.handlePartActivatedFromUI();
            }
        }
    }

    private class P_FormListener
    implements FormListener {
        private P_FormListener() {
        }

        public void formChanged(FormEvent e) throws ProcessingException {
            if (e.getType() == 3010) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AbstractScoutEditorPart.this.closePart();
                    }
                };
                AbstractScoutEditorPart.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    AbstractScoutEditorPart.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                }
            };
            AbstractScoutEditorPart.this.getUiEnvironment().invokeUiLater(t);
        }
    }
}

