/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table.celleditor;

import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.FormFieldPopupEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.IFormFieldPopupEventListener;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutFormFieldPopup;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutTableCellEditor;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RwtScoutEditorCompositeFactory {
    private final RwtScoutTableCellEditor m_tableCellEditor;
    private final RwtScoutTable m_uiTableComposite;

    public RwtScoutEditorCompositeFactory(RwtScoutTableCellEditor tableCellEditor, RwtScoutTable uiTableComposite) {
        this.m_tableCellEditor = tableCellEditor;
        this.m_uiTableComposite = uiTableComposite;
    }

    public IRwtScoutComposite<? extends IFormField> createEditorComposite(Composite parent, IFormField formField, ITableRow scoutRow, IColumn<?> scoutCol) {
        if (formField instanceof IStringField && ((IStringField)formField).isMultilineText()) {
            return this.createEditorCompositeAsPopup(parent, formField, scoutRow, scoutCol);
        }
        return this.m_uiTableComposite.getUiEnvironment().createFormField(parent, formField);
    }

    protected IRwtScoutComposite<? extends IFormField> createEditorCompositeAsPopup(Composite parent, IFormField formField, final ITableRow scoutRow, final IColumn<?> scoutCol) {
        GridData gd = formField.getGridData();
        gd.h = 1;
        gd.w = 0;
        gd.weightY = 1.0;
        gd.weightX = 1.0;
        formField.setGridDataInternal(gd);
        TableColumn swtCol = this.getRwtColumn(scoutCol);
        final RwtScoutTableCellEditor.RwtCellEditor cellEditor = (RwtScoutTableCellEditor.RwtCellEditor)this.m_uiTableComposite.getUiTableViewer().getCellEditors()[this.getRwtColumnIndex(swtCol)];
        int prefWidth = gd.widthInPixel;
        int minWidth = swtCol.getWidth();
        int prefHeight = gd.heightInPixel;
        int minHeight = Math.max(105, this.m_uiTableComposite.getUiTableViewer().getTable().getItemHeight());
        prefHeight = Math.max(prefHeight, minHeight);
        prefWidth = Math.max(prefWidth, minWidth);
        Composite cellEditorComposite = new Composite(parent, 0);
        final RwtScoutFormFieldPopup formFieldDialog = new RwtScoutFormFieldPopup(cellEditorComposite);
        formFieldDialog.setPrefHeight(prefHeight);
        formFieldDialog.setPrefWidth(prefWidth);
        formFieldDialog.setMinHeight(minHeight);
        formFieldDialog.setMinWidth(minWidth);
        formFieldDialog.createUiField(parent, formField, this.m_uiTableComposite.getUiEnvironment());
        final ICellModifier defaultCellModifier = this.m_uiTableComposite.getUiTableViewer().getCellModifier();
        this.m_uiTableComposite.getUiTableViewer().setCellModifier((ICellModifier)this.m_tableCellEditor.createRwtCellModifierForFormFieldDialog(formFieldDialog));
        final RwtScoutTableCellEditor.IFocusDelegate defaultFocusDelegate = cellEditor.getFocusDelegate();
        cellEditor.setFocusDelegate(new RwtScoutTableCellEditor.AbstractFocusDelegate(){

            @Override
            public void doSetFocus() {
                IRwtScoutForm rwtScoutForm = formFieldDialog.getInnerRwtScoutForm();
                if (rwtScoutForm != null) {
                    this.requestFocus((Control)rwtScoutForm.getUiContainer());
                }
            }
        });
        final IFormFieldPopupEventListener popupListener = new IFormFieldPopupEventListener(){

            @Override
            public void handleEvent(FormFieldPopupEvent event) {
                if ((event.getType() & 1) > 0) {
                    cellEditor.stopCellEditing();
                } else if ((event.getType() & 2) > 0) {
                    cellEditor.cancelCellEditing();
                }
                if ((event.getType() & 0x10) > 0) {
                    RwtScoutEditorCompositeFactory.this.m_tableCellEditor.enqueueEditNextTableCell(scoutRow, scoutCol, false);
                } else if ((event.getType() & 8) > 0) {
                    RwtScoutEditorCompositeFactory.this.m_tableCellEditor.enqueueEditNextTableCell(scoutRow, scoutCol, true);
                }
            }
        };
        formFieldDialog.addEventListener(popupListener);
        cellEditor.addDeactivateListener(new RwtScoutTableCellEditor.IDeactivateListener(){

            @Override
            public void canceled(ColumnViewerEditorDeactivationEvent event) {
                this.restoreDefault();
                this.closePopup(1);
            }

            @Override
            public void saved(ColumnViewerEditorDeactivationEvent event) {
                this.restoreDefault();
                this.closePopup(2);
            }

            private void restoreDefault() {
                cellEditor.setFocusDelegate(defaultFocusDelegate);
                RwtScoutEditorCompositeFactory.this.m_uiTableComposite.getUiTableViewer().setCellModifier(defaultCellModifier);
                cellEditor.removeDeactivateListener(this);
            }

            private void closePopup(int popupEvent) {
                if (formFieldDialog.isClosed()) {
                    return;
                }
                formFieldDialog.removeEventListener(popupListener);
                formFieldDialog.closePopup(popupEvent);
            }
        });
        return formFieldDialog;
    }

    private TableColumn getRwtColumn(IColumn<?> scoutCol) {
        TableColumn[] tableColumnArray = this.m_uiTableComposite.getUiTableViewer().getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn swtCol = tableColumnArray[n2];
            IColumn candidate = (IColumn)swtCol.getData("scoutColumn");
            if (candidate != null && CompareUtility.equals((Object)candidate.getColumnId(), (Object)scoutCol.getColumnId())) {
                return swtCol;
            }
            ++n2;
        }
        return null;
    }

    private int getRwtColumnIndex(TableColumn swtCol) {
        Table table = this.m_uiTableComposite.getUiTableViewer().getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumn(i) == swtCol) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

