/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table.celleditor;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutEditorCompositeFactory;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutFormFieldPopup;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutTableCellEditorEventHandler;
import org.eclipse.scout.rt.ui.rap.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RwtScoutTableCellEditor {
    private final RwtScoutTable m_uiTableComposite;
    private final RwtScoutEditorCompositeFactory m_editorCompositeFactory;
    private final RwtScoutTableCellEditorEventHandler m_cellEditorEventHandler;

    public RwtScoutTableCellEditor(RwtScoutTable uiTableComposite) {
        this.m_uiTableComposite = uiTableComposite;
        this.m_editorCompositeFactory = new RwtScoutEditorCompositeFactory(this, this.m_uiTableComposite);
        this.m_cellEditorEventHandler = new RwtScoutTableCellEditorEventHandler(this, uiTableComposite);
    }

    public void initializeUi() {
        TableViewer viewer = this.m_uiTableComposite.getUiTableViewer();
        String[] columnPropertyNames = new String[viewer.getTable().getColumnCount()];
        CellEditor[] oldEditors = viewer.getCellEditors();
        CellEditor[] newEditors = new CellEditor[columnPropertyNames.length];
        int i = 0;
        while (i < columnPropertyNames.length) {
            TableColumn rwtCol = viewer.getTable().getColumn(i);
            IColumn scoutCol = (IColumn)rwtCol.getData("scoutColumn");
            if (scoutCol != null) {
                columnPropertyNames[i] = "" + scoutCol.getColumnIndex();
                if (scoutCol.isEditable()) {
                    newEditors[i] = new RwtCellEditor(viewer.getTable());
                }
            } else {
                columnPropertyNames[i] = "";
            }
            ++i;
        }
        viewer.setCellModifier((ICellModifier)this.createRwtCellModifier());
        viewer.setColumnProperties(columnPropertyNames);
        viewer.setCellEditors(newEditors);
        if (oldEditors != null && oldEditors.length > 0) {
            CellEditor[] cellEditorArray = oldEditors;
            int n = oldEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                if (editor != null) {
                    editor.dispose();
                }
                ++n2;
            }
        }
    }

    protected Control getEditorControl(Composite parent, ITableRow scoutRow, IColumn<?> scoutCol) {
        Composite swtEditorControl = null;
        IRwtScoutComposite<? extends IFormField> editorComposite = this.createEditorComposite(parent, scoutRow, scoutCol);
        if (editorComposite != null) {
            this.decorateEditorComposite(editorComposite, scoutRow, scoutCol);
            swtEditorControl = editorComposite.getUiContainer();
        }
        return swtEditorControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRwtScoutComposite<? extends IFormField> createEditorComposite(Composite parent, final ITableRow scoutRow, final IColumn<?> scoutCol) {
        IFormField formField;
        final AtomicReference fieldRef = new AtomicReference();
        if (scoutRow != null && scoutCol != null) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    fieldRef.set(((ITable)RwtScoutTableCellEditor.this.m_uiTableComposite.getScoutObject()).getUIFacade().prepareCellEditFromUI(scoutRow, scoutCol));
                    AtomicReference atomicReference = fieldRef;
                    synchronized (atomicReference) {
                        fieldRef.notifyAll();
                    }
                }
            };
            AtomicReference atomicReference = fieldRef;
            synchronized (atomicReference) {
                this.m_uiTableComposite.getUiEnvironment().invokeScoutLater(t, 2345L);
                try {
                    fieldRef.wait(2345L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if ((formField = (IFormField)fieldRef.get()) == null) {
            return null;
        }
        IRwtScoutComposite<? extends IFormField> uiScoutFormField = this.m_editorCompositeFactory.createEditorComposite(parent, formField, scoutRow, scoutCol);
        if (uiScoutFormField instanceof IPopupSupport) {
            this.getRwtScoutCellEditorEventHandler().installPopupListenerOnPopupSupport((IPopupSupport)((Object)uiScoutFormField));
        }
        return uiScoutFormField;
    }

    protected void decorateEditorComposite(IRwtScoutComposite<? extends IFormField> editorComposite, ITableRow scoutRow, IColumn<?> scoutCol) {
    }

    protected void saveEditorFromUi() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)RwtScoutTableCellEditor.this.m_uiTableComposite.getScoutObject()).getUIFacade().completeCellEditFromUI();
            }
        };
        this.m_uiTableComposite.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void cancelEditorFromUi() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)RwtScoutTableCellEditor.this.m_uiTableComposite.getScoutObject()).getUIFacade().cancelCellEditFromUI();
            }
        };
        this.m_uiTableComposite.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void enqueueEditNextTableCell(final ITableRow row, final IColumn<?> col, final boolean forward) {
        if (row == null || col == null) {
            return;
        }
        this.m_uiTableComposite.getUiEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                if (RwtScoutTableCellEditor.this.m_uiTableComposite.getUiEnvironment() == null) {
                    return;
                }
                ITable table = (ITable)RwtScoutTableCellEditor.this.m_uiTableComposite.getScoutObject();
                TableUtility.editNextTableCell((ITable)table, (ITableRow)row, (IColumn)col, (boolean)forward, (TableUtility.ITableCellEditorFilter)new TableUtility.ITableCellEditorFilter(){

                    public boolean accept(ITableRow rowx, IColumn<?> colx) {
                        return true;
                    }
                });
            }
        }, 0L);
    }

    protected IColumn<?> getScoutColumn(String property) {
        if (property != null && property.matches("[0-9]+")) {
            int colIndex = Integer.parseInt(property);
            return ((ITable)this.m_uiTableComposite.getScoutObject()).getColumnSet().getColumn(colIndex);
        }
        return null;
    }

    protected RwtScoutTableCellEditorEventHandler getRwtScoutCellEditorEventHandler() {
        return this.m_cellEditorEventHandler;
    }

    protected RwtCellModifier createRwtCellModifier() {
        return new RwtCellModifier();
    }

    protected RwtCellModifier createRwtCellModifierForFormFieldDialog(final RwtScoutFormFieldPopup formFieldDialog) {
        return new RwtCellModifier(this){

            @Override
            public void modify(Object element, String property, Object value) {
                formFieldDialog.touch();
                super.modify(element, property, value);
            }
        };
    }

    static abstract class AbstractFocusDelegate
    implements IFocusDelegate {
        AbstractFocusDelegate() {
        }

        protected boolean requestFocus(Control control) {
            if (control == null || control.isDisposed()) {
                return false;
            }
            if (control.setFocus()) {
                return true;
            }
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (this.requestFocus(child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    static interface IDeactivateListener {
        public void canceled(ColumnViewerEditorDeactivationEvent var1);

        public void saved(ColumnViewerEditorDeactivationEvent var1);
    }

    static interface IFocusDelegate {
        public void doSetFocus();
    }

    class RwtCellEditor
    extends CellEditor {
        private static final long serialVersionUID = 1L;
        private Composite m_container;
        private Object m_value;
        private ITableRow m_editScoutRow;
        private IColumn<?> m_editScoutCol;
        private IFocusDelegate m_focusDelegate;
        private ConcurrentHashMap<IDeactivateListener, Object> m_deactivateListeners;

        protected RwtCellEditor(Table parent) {
            super((Composite)parent);
            this.m_focusDelegate = new P_FocusDelegate();
            this.m_deactivateListeners = new ConcurrentHashMap();
        }

        protected Control createControl(Composite parent) {
            this.m_container = new Composite(parent, 0){
                private static final long serialVersionUID = 1L;

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(wHint, hHint);
                }

                public void setBounds(Rectangle rect) {
                    if (RwtCellEditor.this.m_editScoutCol instanceof IBooleanColumn) {
                        rect.x = Math.max(0, rect.x - 16);
                        rect.width = Math.max(0, rect.width + 16);
                    }
                    super.setBounds(rect);
                }
            };
            this.m_container.setLayout((Layout)new FillLayout());
            RwtScoutTableCellEditor.this.m_uiTableComposite.getUiEnvironment().addKeyStroke((Control)this.m_container, new RwtKeyStroke(13){

                @Override
                public void handleUiAction(Event e) {
                    e.doit = false;
                    RwtCellEditor.this.fireApplyEditorValue();
                    RwtCellEditor.this.deactivate();
                }
            }, false);
            this.m_container.addDisposeListener(new DisposeListener(){
                private static final long serialVersionUID = 1L;

                public void widgetDisposed(DisposeEvent event) {
                    RwtScoutTableCellEditor.this.m_uiTableComposite.getUiEnvironment().removeKeyStrokes((Control)RwtCellEditor.this.m_container);
                }
            });
            return this.m_container;
        }

        protected void doSetFocus() {
            if (this.m_focusDelegate != null) {
                this.m_focusDelegate.doSetFocus();
            }
        }

        protected Object doGetValue() {
            return this.m_value;
        }

        protected void doSetValue(Object value) {
            this.m_value = value;
        }

        public void activate(ColumnViewerEditorActivationEvent e) {
            RwtScoutTableCellEditor.this.getRwtScoutCellEditorEventHandler().activateFocusLostListener();
            RwtScoutTableCellEditor.this.getRwtScoutCellEditorEventHandler().suspendFocusLostListener();
            this.m_editScoutRow = null;
            this.m_editScoutCol = null;
            if (e.getSource() instanceof ViewerCell) {
                ViewerCell cell = (ViewerCell)e.getSource();
                TableViewer viewer = RwtScoutTableCellEditor.this.m_uiTableComposite.getUiTableViewer();
                TableColumn rwtCol = viewer.getTable().getColumn(cell.getColumnIndex());
                IColumn scoutCol = (IColumn)rwtCol.getData("scoutColumn");
                ITableRow scoutRow = (ITableRow)cell.getElement();
                if (e.sourceEvent instanceof MouseEvent && scoutCol instanceof IBooleanColumn) {
                    return;
                }
                if (scoutRow != null && scoutCol != null) {
                    this.m_editScoutRow = scoutRow;
                    this.m_editScoutCol = scoutCol;
                    Control control = RwtScoutTableCellEditor.this.getEditorControl(this.m_container, scoutRow, scoutCol);
                }
                this.m_container.layout(true, true);
                this.m_container.setVisible(true);
            }
        }

        protected void deactivate(ColumnViewerEditorDeactivationEvent e) {
            RwtScoutTableCellEditor.this.getRwtScoutCellEditorEventHandler().deregisterKeyStrokeFromFocusControl();
            RwtScoutTableCellEditor.this.getRwtScoutCellEditorEventHandler().deactivateFocusLostListener();
            for (IDeactivateListener listener : this.m_deactivateListeners.keySet()) {
                if (e.eventType == 2) {
                    listener.saved(e);
                    continue;
                }
                listener.canceled(e);
            }
            this.m_editScoutRow = null;
            this.m_editScoutCol = null;
            Control[] controlArray = this.m_container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            super.deactivate(e);
            if (e.eventType == 1) {
                RwtScoutTableCellEditor.this.cancelEditorFromUi();
            }
        }

        public void stopCellEditing() {
            this.fireApplyEditorValue();
            this.deactivate();
        }

        public void cancelCellEditing() {
            this.fireCancelEditor();
            this.deactivate();
        }

        public IFocusDelegate getFocusDelegate() {
            return this.m_focusDelegate;
        }

        public void setFocusDelegate(IFocusDelegate focusDelegate) {
            this.m_focusDelegate = focusDelegate;
        }

        public void addDeactivateListener(IDeactivateListener listener) {
            this.m_deactivateListeners.put(listener, new Object());
        }

        public void removeDeactivateListener(IDeactivateListener listener) {
            this.m_deactivateListeners.remove(listener);
        }

        public ITableRow getScoutTableRow() {
            return this.m_editScoutRow;
        }

        public IColumn<?> getScoutTableColumn() {
            return this.m_editScoutCol;
        }

        private class P_FocusDelegate
        extends AbstractFocusDelegate {
            private P_FocusDelegate() {
            }

            @Override
            public void doSetFocus() {
                this.requestFocus((Control)RwtCellEditor.this.m_container);
                final Control focusControl = RwtCellEditor.this.m_container.getDisplay().getFocusControl();
                if (focusControl != null && RwtUtility.isAncestorOf((Control)RwtCellEditor.this.m_container, focusControl)) {
                    RwtScoutTableCellEditor.this.m_uiTableComposite.getUiEnvironment().addKeyStroke(focusControl, new RwtKeyStroke(27){

                        @Override
                        public void handleUiAction(Event e) {
                            RwtCellEditor.this.cancelCellEditing();
                            RwtScoutTableCellEditor.this.m_uiTableComposite.getUiEnvironment().removeKeyStroke(focusControl, this);
                            e.doit = false;
                        }
                    }, true);
                    RwtScoutTableCellEditor.this.getRwtScoutCellEditorEventHandler().setupFocusAndTraverseListenerOnFocusControl(focusControl, RwtCellEditor.this);
                }
                RwtScoutTableCellEditor.this.getRwtScoutCellEditorEventHandler().resumeFocusLostListener();
            }
        }
    }

    class RwtCellModifier
    implements ICellModifier {
        private static final String DUMMY_VALUE = "Dummy";

        RwtCellModifier() {
        }

        protected IColumn<?> getScoutColumn(String property) {
            if (property != null && property.matches("[0-9]+")) {
                int colIndex = Integer.parseInt(property);
                return ((ITable)RwtScoutTableCellEditor.this.m_uiTableComposite.getScoutObject()).getColumnSet().getColumn(colIndex);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            RwtScoutTableCellEditor.this.saveEditorFromUi();
        }

        public Object getValue(Object element, String property) {
            return DUMMY_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canModify(Object element, String property) {
            AtomicBoolean b;
            final ITable table = (ITable)RwtScoutTableCellEditor.this.m_uiTableComposite.getScoutObject();
            final ITableRow row = (ITableRow)element;
            final IColumn<?> column = this.getScoutColumn(property);
            AtomicBoolean atomicBoolean = b = new AtomicBoolean();
            synchronized (atomicBoolean) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicBoolean atomicBoolean = b;
                        synchronized (atomicBoolean) {
                            try {
                                if (table != null && row != null && column != null) {
                                    b.set(table.isCellEditable(row, column));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            b.notifyAll();
                        }
                    }
                };
                RwtScoutTableCellEditor.this.m_uiTableComposite.getUiEnvironment().invokeScoutLater(r, 2345L);
                try {
                    b.wait(2345L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return b.get();
        }
    }
}

