/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields;

import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;

public final class LogicalGridDataBuilder {
    public static final int FIELD_GRID_X = 1;
    public static final int FIELD_GRID_Y = 1;

    private LogicalGridDataBuilder() {
    }

    public static LogicalGridData createLabel(GridData correspondingFieldData) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 0;
        data.gridy = 1;
        data.gridh = correspondingFieldData.h;
        data.weighty = 1.0;
        data.widthHint = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelWidth();
        data.useUiWidth = true;
        data.useUiHeight = true;
        data.fillVertical = false;
        data.topInset = 1;
        return data;
    }

    public static LogicalGridData createLabelOnTop(GridData correspondingFieldData) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 1;
        data.gridy = 0;
        data.weighty = 0.0;
        data.weightx = 1.0;
        data.useUiWidth = true;
        data.useUiHeight = true;
        data.fillVertical = true;
        data.fillHorizontal = true;
        return data;
    }

    public static LogicalGridData createField(GridData gd) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 1;
        data.gridy = 1;
        data.weightx = 1.0;
        data.gridh = gd.h;
        data.weighty = gd.weightY == 0.0 || gd.weightY < 0.0 && gd.h <= 1 ? 0.0 : 1.0;
        data.useUiWidth = gd.useUiWidth;
        data.useUiHeight = gd.useUiHeight;
        return data;
    }
}

