/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.servletfilter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.commons.servletfilter.FilterConfigInjection;

public class LogoutFilter
implements Filter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LogoutFilter.class);
    private static final String DOIT_PARAM = "doit";
    public static final String LOGOUT_PARAM = "doLogout";
    public static final String REDIRECT_PARAM = "redirectUrl";
    public static final String RELOAD_ON_SESSION_TIMEOUT_PARAM = "reloadOnSessionTimeout";
    private FilterConfigInjection m_injection;

    public void init(FilterConfig config0) throws ServletException {
        this.m_injection = new FilterConfigInjection(config0, this.getClass());
    }

    public void destroy() {
        this.m_injection = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String redirectLocation;
        boolean abortChain;
        FilterConfigInjection.FilterConfig config = this.m_injection.getConfig(request);
        if (!config.isActive()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);
        if ((session == null || session.isNew()) && (abortChain = this.handleSessionTimeout(config, httpRequest, httpResponse))) {
            return;
        }
        String logoutParam = request.getParameter(LOGOUT_PARAM);
        if (logoutParam == null) {
            chain.doFilter(request, response);
            return;
        }
        String doitParamValue = request.getParameter(DOIT_PARAM);
        if (!StringUtility.hasText((String)doitParamValue)) {
            this.forceClientSideReload(config, httpRequest, httpResponse);
            return;
        }
        if (session != null) {
            session.invalidate();
            LOG.info("Logout successful.");
        }
        if (StringUtility.hasText((String)(redirectLocation = this.computeRedirectLocation(config, httpRequest)))) {
            httpResponse.sendRedirect(httpResponse.encodeRedirectURL(redirectLocation));
        }
    }

    protected boolean handleSessionTimeout(FilterConfigInjection.FilterConfig config, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String reloadOnSessionTimeout = config.getInitParameter(RELOAD_ON_SESSION_TIMEOUT_PARAM);
        if (!Boolean.parseBoolean(reloadOnSessionTimeout)) {
            return false;
        }
        String contentType = request.getHeader("Content-Type");
        if (contentType == null || !contentType.contains("application/json")) {
            return false;
        }
        String referer = request.getHeader("Referer");
        int index = referer.indexOf(35);
        if (index >= 0) {
            referer = referer.substring(0, index);
        }
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().write("{ \"head\": { \"redirect\": \"" + referer + "\"},\"operations\": [] }");
        LOG.info("Site reload after session timeout initiated.");
        return true;
    }

    protected void forceClientSideReload(FilterConfigInjection.FilterConfig config, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectHtmlTemplate = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><html><head>  <script language=\"javascript\">  function redirect() {location.replace('#redirectUrl#');}  </script><title></title></head><body onLoad=\"redirect()\"></body></html>";
        String servletPath = request.getServletPath();
        if (servletPath.length() > 0 && '/' == servletPath.charAt(0)) {
            servletPath = servletPath.substring(1);
        }
        servletPath = String.valueOf(servletPath) + "?doLogout=true";
        servletPath = String.valueOf(servletPath) + "&doit=true";
        String redirectParamValue = this.computeRedirectLocation(config, request);
        if (StringUtility.hasText((String)redirectParamValue)) {
            servletPath = String.valueOf(servletPath) + "&redirectUrl=" + redirectParamValue;
        }
        servletPath = response.encodeRedirectURL(servletPath);
        String redirectHtml = redirectHtmlTemplate.replace("#redirectUrl#", servletPath);
        response.setContentType("text/html");
        response.getWriter().print(redirectHtml);
    }

    protected String computeRedirectLocation(FilterConfigInjection.FilterConfig config, HttpServletRequest request) {
        String redirectLocation = config.getInitParameter(REDIRECT_PARAM);
        if (!StringUtility.hasText((String)redirectLocation)) {
            redirectLocation = request.getParameter(REDIRECT_PARAM);
        }
        if (!StringUtility.hasText((String)redirectLocation) && (redirectLocation = request.getServletPath()).length() > 0 && '/' == redirectLocation.charAt(0)) {
            redirectLocation = redirectLocation.substring(1);
        }
        return redirectLocation;
    }
}

