/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service.internal;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.service.internal.ServicesExtensionManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.service";
    private static Activator plugin;
    private ServicesExtensionManager m_servicesExtensionManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ServiceReference ref = context.getServiceReference(IExtensionRegistry.class.getName());
        IExtensionRegistry reg = (IExtensionRegistry)context.getService(ref);
        context.ungetService(ref);
        this.m_servicesExtensionManager = new ServicesExtensionManager(reg, "org.eclipse.scout.service.services");
        context.addBundleListener((BundleListener)new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2 && event.getBundle().equals(Activator.this.getBundle())) {
                    new Job("Initialize services"){

                        protected IStatus run(IProgressMonitor monitor) {
                            Activator.this.m_servicesExtensionManager.start();
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        if (this.m_servicesExtensionManager != null) {
            this.m_servicesExtensionManager.stop();
            this.m_servicesExtensionManager = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ServicesExtensionManager getServicesExtensionManager() {
        return this.m_servicesExtensionManager;
    }
}

