/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.exception;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;

public class PlaceholderException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String m_origThrowableClassName;

    public PlaceholderException(Throwable t, Throwable cause) {
        super(t.getMessage(), cause);
        this.setStackTrace(t.getStackTrace());
        this.m_origThrowableClassName = t.getClass().getName();
    }

    @Override
    public String toString() {
        String s = this.m_origThrowableClassName;
        String message = this.getLocalizedMessage();
        return message != null ? String.valueOf(s) + ": " + message : s;
    }

    public String getOrigThrowableClassName() {
        return this.m_origThrowableClassName;
    }

    public static Throwable transformException(Throwable t) {
        ArrayList<Throwable> throwableStack = new ArrayList<Throwable>();
        while (t != null) {
            throwableStack.add(0, t);
            t = t.getCause();
        }
        Throwable cause = null;
        for (Throwable throwable : throwableStack) {
            Throwable transformedThrowable = null;
            if (throwable instanceof ProcessingException) {
                ProcessingException pe = null;
                IProcessingStatus oldStatus = ((ProcessingException)throwable).getStatus();
                ProcessingStatus newStatus = oldStatus instanceof ProcessingStatus ? (ProcessingStatus)oldStatus : new ProcessingStatus(oldStatus);
                newStatus.setException(cause);
                try {
                    pe = (ProcessingException)PlaceholderException.transformWellKnownException(throwable, cause, newStatus);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                if (pe == null) {
                    pe = new ProcessingException();
                }
                pe.setStatus(newStatus);
                transformedThrowable = pe;
            } else if (throwable.getClass().getPackage() != null && throwable.getClass().getPackage().getName().startsWith("java.")) {
                transformedThrowable = PlaceholderException.transformWellKnownException(throwable, cause, null);
            }
            if (transformedThrowable == null) {
                transformedThrowable = new PlaceholderException(throwable, cause);
            }
            transformedThrowable.setStackTrace(throwable.getStackTrace());
            cause = transformedThrowable;
        }
        return cause;
    }

    private static Throwable transformWellKnownException(Throwable throwable, Throwable cause, IProcessingStatus processingStatus) {
        Constructor<?> ctor2;
        Class<?> clazz = throwable.getClass();
        Throwable transformedThrowable = null;
        if (throwable instanceof ProcessingException) {
            try {
                ctor2 = clazz.getConstructor(IProcessingStatus.class);
                if (ctor2 != null) {
                    transformedThrowable = (Throwable)ctor2.newInstance(processingStatus);
                }
            }
            catch (Exception ctor2) {
                // empty catch block
            }
        }
        if (transformedThrowable == null) {
            try {
                ctor2 = clazz.getConstructor(String.class, Throwable.class);
                if (ctor2 != null) {
                    transformedThrowable = (Throwable)ctor2.newInstance(throwable.getMessage(), cause);
                }
            }
            catch (Exception ctor3) {
                // empty catch block
            }
        }
        if (transformedThrowable == null && cause == null) {
            try {
                ctor2 = clazz.getConstructor(String.class);
                if (ctor2 != null) {
                    transformedThrowable = (Throwable)ctor2.newInstance(throwable.getMessage());
                }
            }
            catch (Exception ctor4) {
                // empty catch block
            }
        }
        if (transformedThrowable == null && throwable.getMessage() == null) {
            try {
                ctor2 = clazz.getConstructor(Throwable.class);
                if (ctor2 != null) {
                    transformedThrowable = (Throwable)ctor2.newInstance(cause);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (transformedThrowable == null && cause == null) {
            try {
                transformedThrowable = (Throwable)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return transformedThrowable;
    }
}

