/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.analysis;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.logger.analysis.AbstractLogFilter;
import org.eclipse.scout.commons.logger.analysis.ILogFilter;
import org.eclipse.scout.commons.logger.analysis.LogCategory;
import org.eclipse.scout.commons.logger.analysis.LogEntry;

public class LogAnalyzer {
    private int m_totalCount;
    private int m_filterCount;
    private ArrayList<LogCategory> m_categories;

    public void start(File in, File out, ILogFilter filter) throws Exception {
        File tmp = new File(String.valueOf(out.getAbsolutePath()) + ".tmp");
        tmp.deleteOnExit();
        this.start(new FileReader(in), new FileWriter(tmp), filter);
        if (out.exists() && !out.delete()) {
            throw new IOException("Cannot delete old version of " + out);
        }
        tmp.renameTo(out);
    }

    public void start(ILogFilter filter) throws Exception {
        DataFlavor f;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (!t.isDataFlavorSupported(f = DataFlavor.getTextPlainUnicodeFlavor())) {
            throw new IOException("Expected COPY/PASTE text");
        }
        StringWriter out = new StringWriter();
        this.start(f.getReaderForText(t), out, filter);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(out.getBuffer().toString()), null);
        System.out.println("PASTED text to clipboard");
    }

    public void start(Reader in, Writer out, ILogFilter filter) throws Exception {
        this.analyze(in, out, filter);
    }

    private void analyze(Reader in, Writer out, ILogFilter filter) throws Exception {
        this.m_totalCount = 0;
        this.m_filterCount = 0;
        this.m_categories = new ArrayList();
        BufferedReader r = new BufferedReader(in);
        try {
            String line;
            ArrayList<String> buf = null;
            while ((line = r.readLine()) != null) {
                if (filter.isIgnoredLine(line)) {
                    System.out.println("ignoring line: " + line);
                    continue;
                }
                if (filter.isLogEntryStartLine(line)) {
                    this.analyzeBuffer(buf, out, filter);
                    buf = new ArrayList<String>();
                }
                if (buf == null) continue;
                buf.add(line);
            }
            this.analyzeBuffer(buf, out, filter);
            TreeMap<CompositeObject, LogCategory> sortMap = new TreeMap<CompositeObject, LogCategory>();
            int index = 0;
            for (LogCategory c : this.m_categories) {
                sortMap.put(new CompositeObject(-c.getEntryCount(), index), c);
                ++index;
            }
            for (LogCategory c : sortMap.values()) {
                out.write(c.format(filter));
                out.write("\n");
            }
            System.out.println("TOTAL " + this.m_totalCount + " entries\nACCEPTED " + this.m_filterCount + " in " + this.m_categories.size() + " CATEGORIES");
        }
        finally {
            try {
                r.close();
            }
            catch (Throwable throwable) {}
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void analyzeBuffer(List<String> buf, Writer out, ILogFilter filter) throws Exception {
        if (buf != null && buf.size() > 0) {
            ++this.m_totalCount;
            LogEntry e = filter.parse(buf);
            if ((e = filter.filter(e)) != null) {
                ++this.m_filterCount;
                LogCategory c = null;
                for (LogCategory cat : this.m_categories) {
                    if (!cat.isCategoryFor(e)) continue;
                    c = cat;
                    break;
                }
                if (c == null) {
                    c = new LogCategory(e);
                    this.m_categories.add(c);
                }
                c.add(e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        AbstractLogFilter filter = new AbstractLogFilter(){

            @Override
            public LogEntry filter(LogEntry e) {
                return e;
            }
        };
        new LogAnalyzer().start(filter);
    }
}

