/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.commons.mail.MailAttachment;

public class MailMessage {
    private final List<String> m_toRecipients = new ArrayList<String>();
    private final List<String> m_ccRecipients = new ArrayList<String>();
    private final List<String> m_bccRecipients = new ArrayList<String>();
    private String m_sender;
    private String m_subject;
    private String m_bodyPlainText;
    private String m_bodyHtml;
    private final List<MailAttachment> m_attachments = new ArrayList<MailAttachment>();

    public MailMessage() {
        this(null, null);
    }

    public MailMessage(String bodyPlainText, String bodyHtml) {
        this(bodyPlainText, bodyHtml, null, null, null);
    }

    public MailMessage(String bodyPlainText, String bodyHtml, String subject, String sender, List<String> toRecipients) {
        this.m_bodyPlainText = bodyPlainText;
        this.m_bodyHtml = bodyHtml;
        this.m_subject = subject;
        this.m_sender = sender;
        this.addToRecipients(toRecipients);
    }

    public List<String> getToRecipients() {
        return Collections.unmodifiableList(this.m_toRecipients);
    }

    public void addToRecipient(String toRecipient) {
        this.m_toRecipients.add(toRecipient);
    }

    public void addToRecipients(Collection<String> toRecipients) {
        if (toRecipients != null) {
            this.m_toRecipients.addAll(toRecipients);
        }
    }

    public void clearToRecipients() {
        this.m_toRecipients.clear();
    }

    public List<String> getCcRecipients() {
        return Collections.unmodifiableList(this.m_ccRecipients);
    }

    public void addCcRecipient(String ccRecipient) {
        this.m_ccRecipients.add(ccRecipient);
    }

    public void addCcRecipients(Collection<String> ccRecipients) {
        if (ccRecipients != null) {
            this.m_ccRecipients.addAll(ccRecipients);
        }
    }

    public void clearCcRecipients() {
        this.m_ccRecipients.clear();
    }

    public List<String> getBccRecipients() {
        return Collections.unmodifiableList(this.m_bccRecipients);
    }

    public void addBccRecipient(String bccRecipient) {
        this.m_bccRecipients.add(bccRecipient);
    }

    public void addBccRecipients(Collection<String> bccRecipients) {
        if (bccRecipients != null) {
            this.m_bccRecipients.addAll(bccRecipients);
        }
    }

    public void clearBccRecipients() {
        this.m_bccRecipients.clear();
    }

    public String getSender() {
        return this.m_sender;
    }

    public void setSender(String sender) {
        this.m_sender = sender;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public String getBodyPlainText() {
        return this.m_bodyPlainText;
    }

    public void setBodyPlainText(String bodyPlainText) {
        this.m_bodyPlainText = bodyPlainText;
    }

    public String getBodyHtml() {
        return this.m_bodyHtml;
    }

    public void setBodyHtml(String bodyHtml) {
        this.m_bodyHtml = bodyHtml;
    }

    public List<MailAttachment> getAttachments() {
        return Collections.unmodifiableList(this.m_attachments);
    }

    public void addAttachment(MailAttachment attachment) {
        this.m_attachments.add(attachment);
    }

    public void addAttachments(Collection<MailAttachment> attachments) {
        this.m_attachments.addAll(attachments);
    }

    public void clearAttachments() {
        this.m_attachments.clear();
    }
}

