/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal;

import javax.xml.ws.handler.MessageContext;
import org.eclipse.scout.jaxws.internal.SessionContextBean;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.rt.server.IServerSession;

public final class ContextHelper {
    public static final String PROP_SESSION_CONTEXT = "org.eclipse.scout.jaxws.internal.session";
    public static final String PROP_SESSION_FACTORY_PORT_TYPE = "org.eclipse.scout.jaxws.internal.session.factory.porttype";

    private ContextHelper() {
    }

    public static IServerSession getContextSession(MessageContext context) {
        Object object = context.get((Object)PROP_SESSION_CONTEXT);
        if (object instanceof SessionContextBean) {
            return ((SessionContextBean)object).getSession();
        }
        return null;
    }

    public static Class<? extends IServerSessionFactory> getContextSessionFactoryClass(MessageContext context) {
        Object object = context.get((Object)PROP_SESSION_CONTEXT);
        if (object instanceof SessionContextBean) {
            return ((SessionContextBean)object).getFactoryClass();
        }
        return null;
    }

    public static IServerSessionFactory getPortTypeSessionFactory(MessageContext context) {
        Object object = context.get((Object)PROP_SESSION_FACTORY_PORT_TYPE);
        if (object instanceof IServerSessionFactory) {
            return (IServerSessionFactory)object;
        }
        return null;
    }

    public static void setContextSession(MessageContext context, IServerSessionFactory factory, IServerSession session) {
        if (factory == null || session == null) {
            context.remove((Object)PROP_SESSION_CONTEXT);
        } else {
            context.put((Object)PROP_SESSION_CONTEXT, (Object)new SessionContextBean(factory.getClass(), session));
            context.setScope(PROP_SESSION_CONTEXT, MessageContext.Scope.APPLICATION);
        }
    }

    public static void setPortTypeSessionFactory(MessageContext context, IServerSessionFactory factory) {
        if (factory == null) {
            context.remove((Object)PROP_SESSION_FACTORY_PORT_TYPE);
        } else {
            context.put((Object)PROP_SESSION_FACTORY_PORT_TYPE, (Object)factory);
            context.setScope(PROP_SESSION_FACTORY_PORT_TYPE, MessageContext.Scope.HANDLER);
        }
    }
}

