/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.ui.part;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTypeEditorInput;
import org.eclipse.scout.nls.sdk.services.ui.page.TextServiceNodePage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.ILink;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.TypeOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NlsPropertyViewPart
extends JdtTypePropertyPart {
    private static final String SECTION_ID_LINKS = "section.links";

    public TextServiceNodePage getPage() {
        return (TextServiceNodePage)super.getPage();
    }

    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, Texts.get((String)"Links"));
        this.fillLinkSection(linkSection.getSectionClient());
        super.createSections();
    }

    protected void fillLinkSection(Composite parent) {
        IType serviceType;
        LinksPresenterModel model = new LinksPresenterModel();
        IScoutBundle bundle = this.getPage().getScoutBundle();
        if (bundle != null && TypeUtility.exists((IJavaElement)(serviceType = this.getPage().getType()))) {
            TypeOpenLink link = new TypeOpenLink(serviceType){

                public void execute() {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        activePage.openEditor((IEditorInput)new NlsTypeEditorInput(serviceType), "org.eclipse.scout.nls.sdk.nlsEditor", true, 3);
                    }
                    catch (PartInitException e) {
                        ScoutSdkUi.logError((String)("Unable to open NLS editor for type '" + serviceType.getFullyQualifiedName() + "'."), (Throwable)e);
                    }
                }
            };
            link.setName(Texts.get((String)"OpenNlsEditor"));
            model.addGlobalLink((ILink)link);
        }
        LinksPresenter presenter = new LinksPresenter(this.getFormToolkit(), parent, model);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
    }
}

