/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;

public class ClientJobContext
implements Iterable<Map.Entry<Object, Object>> {
    private Map<Object, Object> m_properties;

    public ClientJobContext() {
    }

    public ClientJobContext(ClientJobContext properties) {
        if (properties != null && properties.m_properties != null && properties.m_properties.size() > 0) {
            this.m_properties = CollectionUtility.copyMap(properties.m_properties);
        }
    }

    public Object get(Object key) {
        if (this.m_properties == null || key == null) {
            return null;
        }
        return this.m_properties.get(key);
    }

    public void set(Object key, Object value) {
        if (value == null) {
            if (this.m_properties == null) {
                return;
            }
            this.m_properties.remove(key);
            if (this.m_properties.isEmpty()) {
                this.m_properties = null;
            }
        } else {
            if (this.m_properties == null) {
                this.m_properties = new HashMap<Object, Object>(5);
            }
            this.m_properties.put(key, value);
        }
    }

    public void clear() {
        if (this.m_properties == null) {
            return;
        }
        this.m_properties = null;
    }

    @Override
    public Iterator<Map.Entry<Object, Object>> iterator() {
        if (this.m_properties == null) {
            return Collections.emptyMap().entrySet().iterator();
        }
        return this.m_properties.entrySet().iterator();
    }
}

