/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.bookmark;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceEvent;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceListener;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.menu.ActivateBookmarkKeyStroke;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkData;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkVisitor;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.ServiceRegistration;

@Priority(value=-3.0f)
public class BookmarkService
extends AbstractService
implements IBookmarkService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BookmarkService.class);
    private static final String SESSION_DATA_KEY = "bookmarkServiceState";

    private ServiceState getServiceState() {
        IClientSession session = ClientJob.getCurrentSession();
        if (session == null) {
            throw new IllegalStateException("null client session in current job context");
        }
        ServiceState data = (ServiceState)session.getData(SESSION_DATA_KEY);
        if (data == null) {
            data = new ServiceState();
            data.m_model = new BookmarkData();
            session.setData(SESSION_DATA_KEY, data);
        }
        return data;
    }

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.addBookmarkServiceListener(new BookmarkServiceListener(){

            @Override
            public void bookmarksChanged(BookmarkServiceEvent e) {
                BookmarkService.this.handleBookmarksChangedInternal(e);
            }
        });
    }

    protected void handleBookmarksChangedInternal(BookmarkServiceEvent e) {
        switch (e.getType()) {
            case 10: {
                final ArrayList list = new ArrayList();
                IBookmarkVisitor visitor = new IBookmarkVisitor(){

                    public boolean visitFolder(List<BookmarkFolder> path) {
                        return true;
                    }

                    public boolean visitBookmark(List<BookmarkFolder> path, Bookmark b) {
                        if (b.getKeyStroke() != null) {
                            list.add(b);
                        }
                        return true;
                    }
                };
                this.getBookmarkData().getUserBookmarks().visit(visitor);
                this.getBookmarkData().getGlobalBookmarks().visit(visitor);
                IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
                if (desktop == null) break;
                ArrayList<IKeyStroke> newKeyStrokes = new ArrayList<IKeyStroke>();
                for (IKeyStroke k : desktop.getKeyStrokes()) {
                    if (k instanceof ActivateBookmarkKeyStroke) continue;
                    newKeyStrokes.add(k);
                }
                for (Bookmark b : list) {
                    ActivateBookmarkKeyStroke k = new ActivateBookmarkKeyStroke(b);
                    k.prepareAction();
                    newKeyStrokes.add(k);
                }
                desktop.setKeyStrokes(newKeyStrokes);
            }
        }
    }

    @Override
    public void loadBookmarks() throws ProcessingException {
        IBookmarkStorageService storageService = (IBookmarkStorageService)SERVICES.getService(IBookmarkStorageService.class);
        this.importBookmarks(storageService.getBookmarkData());
    }

    @Override
    public void storeBookmarks() throws ProcessingException {
        ServiceState state = this.getServiceState();
        IBookmarkStorageService storageService = (IBookmarkStorageService)SERVICES.getService(IBookmarkStorageService.class);
        this.importBookmarks(storageService.storeBookmarkData(state.m_model));
    }

    @Override
    public void setStartBookmark() throws ProcessingException {
        ServiceState state = this.getServiceState();
        Bookmark b = ClientSyncJob.getCurrentSession().getDesktop().createBookmark();
        if (b != null) {
            b.setKind(1);
            state.m_model.getUserBookmarks().setStartupBookmark(b);
        }
    }

    @Override
    public void deleteStartBookmark() throws ProcessingException {
        ServiceState state = this.getServiceState();
        state.m_model.getUserBookmarks().setStartupBookmark(null);
    }

    @Override
    public Bookmark getStartBookmark() {
        ServiceState state = this.getServiceState();
        Bookmark b = state.m_model.getUserBookmarks().getStartupBookmark();
        if (b == null) {
            b = state.m_model.getGlobalBookmarks().getStartupBookmark();
        }
        return b;
    }

    @Override
    public final BookmarkData getBookmarkData() {
        ServiceState state = this.getServiceState();
        return state.m_model;
    }

    @Override
    public void activate(Bookmark b) throws ProcessingException {
        if (b != null) {
            try {
                ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(b);
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
        }
    }

    @Override
    public void updateBookmark(Bookmark bm) throws ProcessingException {
        Bookmark newBookmark = ClientSyncJob.getCurrentSession().getDesktop().createBookmark();
        int cachedKind = bm.getKind();
        String cachedIconId = bm.getIconId();
        String cachedTitle = bm.getTitle();
        String cachedKeyStroke = bm.getKeyStroke();
        bm.setSerializedData(newBookmark.getSerializedData());
        bm.setKind(cachedKind);
        bm.setIconId(cachedIconId);
        bm.setTitle(cachedTitle);
        bm.setKeyStroke(cachedKeyStroke);
    }

    @Override
    public void addBookmarkServiceListener(BookmarkServiceListener listener) {
        ServiceState state = this.getServiceState();
        state.m_listenerList.add(BookmarkServiceListener.class, (EventListener)listener);
    }

    @Override
    public void removeBookmarkServiceListener(BookmarkServiceListener listener) {
        ServiceState state = this.getServiceState();
        state.m_listenerList.remove(BookmarkServiceListener.class, (EventListener)listener);
    }

    private void fireBookmarksChanged() {
        BookmarkServiceEvent e = new BookmarkServiceEvent(this, 10);
        this.fireBookmarkSeviceEvent(e);
    }

    private void fireBookmarkSeviceEvent(BookmarkServiceEvent e) {
        ServiceState state = this.getServiceState();
        EventListener[] a = state.m_listenerList.getListeners(BookmarkServiceListener.class);
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                ((BookmarkServiceListener)a[i]).bookmarksChanged(e);
                ++i;
            }
        }
    }

    private void importBookmarks(BookmarkData model) throws ProcessingException {
        ServiceState state = this.getServiceState();
        state.m_model.setUserBookmarks(model.getUserBookmarks());
        state.m_model.setGlobalBookmarks(model.getGlobalBookmarks());
        this.fireBookmarksChanged();
    }

    private static class ServiceState {
        EventListenerList m_listenerList = new EventListenerList();
        BookmarkData m_model;

        private ServiceState() {
        }
    }
}

