/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.clientnotification.internal;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-3.0f)
public class ClientNotificationConsumerService
extends AbstractService
implements IClientNotificationConsumerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientNotificationConsumerService.class);
    private static final String SESSION_DATA_KEY = "clientNotificationConsumerServiceState";
    private final ServiceState m_globalServiceState = new ServiceState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceState getServiceState(IClientSession session) {
        if (session == null) {
            throw new IllegalStateException("session is null");
        }
        IClientSession iClientSession = session;
        synchronized (iClientSession) {
            ServiceState data = (ServiceState)session.getData(SESSION_DATA_KEY);
            if (data == null) {
                data = new ServiceState();
                session.setData(SESSION_DATA_KEY, data);
            }
            return data;
        }
    }

    @Override
    public void dispatchClientNotifications(Collection<? extends IClientNotification> notifications0, final IClientSession session) {
        final HashSet notifications = CollectionUtility.hashSetWithoutNullElements(notifications0);
        if (notifications.isEmpty()) {
            return;
        }
        if (ClientJob.getCurrentSession() == session) {
            this.fireEvent(session, notifications, true);
        } else {
            new ClientAsyncJob("Dispatch client notifications", session){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    ClientNotificationConsumerService.this.fireEvent(session, notifications, false);
                }
            }.schedule();
        }
    }

    private void fireEvent(IClientSession session, Set<IClientNotification> notifications, boolean sync) {
        this.getServiceState(session).fireEvent(notifications, sync, this);
        this.m_globalServiceState.fireEvent(notifications, sync, this);
    }

    @Override
    public void addClientNotificationConsumerListener(IClientSession session, IClientNotificationConsumerListener listener) {
        this.getServiceState(session).addListener(listener);
    }

    @Override
    public void removeClientNotificationConsumerListener(IClientSession session, IClientNotificationConsumerListener listener) {
        this.getServiceState(session).removeListener(listener);
    }

    @Override
    public void addGlobalClientNotificationConsumerListener(IClientNotificationConsumerListener listener) {
        this.m_globalServiceState.addListener(listener);
    }

    @Override
    public void removeGlobalClientNotificationConsumerListener(IClientNotificationConsumerListener listener) {
        this.m_globalServiceState.removeListener(listener);
    }

    @Override
    public Set<String> getConsumedNotificationIds(IClientSession session) {
        return this.getServiceState(session).getConsumedIds();
    }

    @Override
    public Set<String> getGlobalConsumedNotificationIds() {
        return this.m_globalServiceState.getConsumedIds();
    }

    public void removeConsumedNotificationIds(Set<String> cnIds, IClientSession session) {
        this.getServiceState(session).removeConsumedIds(cnIds);
    }

    public void removeGlobalConsumedNotificationIds(Set<String> cnIds) {
        this.m_globalServiceState.removeConsumedIds(cnIds);
    }

    private static class ServiceState {
        private final EventListenerList m_listenerList = new EventListenerList();
        private final ConcurrentHashMap<String, Long> m_consumedIds = new ConcurrentHashMap();

        private ServiceState() {
        }

        public Set<String> getConsumedIds() {
            return CollectionUtility.hashSet((Collection)this.m_consumedIds.keySet());
        }

        public void removeConsumedIds(Collection<String> cnIds) {
            for (String id : cnIds) {
                this.m_consumedIds.remove(id);
            }
        }

        public void addListener(IClientNotificationConsumerListener listener) {
            this.m_listenerList.add(IClientNotificationConsumerListener.class, (EventListener)listener);
        }

        public void removeListener(IClientNotificationConsumerListener listener) {
            this.m_listenerList.remove(IClientNotificationConsumerListener.class, (EventListener)listener);
        }

        public void fireEvent(Set<IClientNotification> notifications, boolean sync, IClientNotificationConsumerService service) {
            for (IClientNotification n : notifications) {
                ClientNotificationConsumerEvent event = new ClientNotificationConsumerEvent(service, n);
                this.fireEvent(n, sync, event);
            }
            this.cleanupExpiredNotifications();
        }

        private void fireEvent(IClientNotification notification, boolean sync, ClientNotificationConsumerEvent e) {
            Long validUntil = System.currentTimeMillis() + notification.getTimeout();
            Long previousValue = this.m_consumedIds.putIfAbsent(notification.getId(), validUntil);
            if (previousValue == null) {
                this.fireEventInternal(notification, sync, e);
            }
        }

        private void fireEventInternal(IClientNotification notification, boolean sync, ClientNotificationConsumerEvent e) {
            IClientNotificationConsumerListener[] listeners;
            IClientNotificationConsumerListener[] iClientNotificationConsumerListenerArray = listeners = (IClientNotificationConsumerListener[])this.m_listenerList.getListeners(IClientNotificationConsumerListener.class);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IClientNotificationConsumerListener l = iClientNotificationConsumerListenerArray[n2];
                try {
                    l.handleEvent(e, sync);
                }
                catch (Throwable t) {
                    LOG.error("Listener " + l.getClass().getName() + " on event " + notification, t);
                }
                ++n2;
            }
        }

        private void cleanupExpiredNotifications() {
            for (Map.Entry<String, Long> e : this.m_consumedIds.entrySet()) {
                if (!this.isExpired(e.getValue())) continue;
                this.m_consumedIds.remove(e.getKey());
            }
        }

        private boolean isExpired(long validUntil) {
            return System.currentTimeMillis() >= validUntil;
        }
    }
}

