/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.progress.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.progress.ISimpleProgress;
import org.eclipse.scout.rt.client.services.common.progress.ISimpleProgressService;
import org.eclipse.scout.rt.client.services.common.progress.internal.SimpleProgress;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-1.0f)
public class SimpleProgressService
extends AbstractService
implements ISimpleProgressService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SimpleProgressService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISimpleProgress addProgress(String name) {
        final Holder monitorHolder = new Holder(SimpleProgress.class);
        Job job = new Job(name){
            private boolean m_done;
            private final Object m_doneLock;
            {
                super($anonymous0);
                this.m_doneLock = new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                Object object = monitorHolder;
                synchronized (object) {
                    SimpleProgress p = new SimpleProgress(this, monitor){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void done() {
                            super.done();
                            Object object = m_doneLock;
                            synchronized (object) {
                                m_done = true;
                                m_doneLock.notify();
                            }
                        }
                    };
                    monitorHolder.setValue((Object)p);
                    monitorHolder.notifyAll();
                }
                object = this.m_doneLock;
                synchronized (object) {
                    while (!monitor.isCanceled()) {
                        if (this.m_done) {
                            return Status.OK_STATUS;
                        }
                        try {
                            this.m_doneLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return Status.OK_STATUS;
                }
            }
        };
        Holder holder = monitorHolder;
        synchronized (holder) {
            job.schedule();
            try {
                monitorHolder.wait(10000L);
                if (monitorHolder.getValue() != null) {
                    return (ISimpleProgress)monitorHolder.getValue();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return new SimpleProgress(job, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public void removeProgress(ISimpleProgress monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }
}

