/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IStringColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;

@ClassId(value="e564abbc-5f57-4ccc-a50c-003c408df519")
public abstract class AbstractStringColumn
extends AbstractColumn<String>
implements IStringColumn {
    @ConfigProperty(value="INTEGER")
    @Order(value=130.0)
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected boolean getConfiguredInputMasked() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=150.0)
    protected String getConfiguredDisplayFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredTextWrap() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=170.0)
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    protected boolean getConfiguredSelectAllOnEdit() {
        return true;
    }

    @Deprecated
    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    protected boolean getConfiguredValidateOnAnyKey() {
        return false;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setInputMasked(this.getConfiguredInputMasked());
        this.setDisplayFormat(this.getConfiguredDisplayFormat());
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setTextWrap(this.getConfiguredTextWrap());
        this.setSelectAllOnEdit(this.getConfiguredSelectAllOnEdit());
        this.setValidateOnAnyKey(this.getConfiguredValidateOnAnyKey());
    }

    @Override
    public void setInputMasked(boolean b) {
        this.propertySupport.setPropertyBool("inputMasked", b);
    }

    @Override
    public boolean isInputMasked() {
        return this.propertySupport.getPropertyBool("inputMasked");
    }

    @Override
    public void setDisplayFormat(String s) {
        this.propertySupport.setPropertyString("format", s);
    }

    @Override
    public String getDisplayFormat() {
        return this.propertySupport.getPropertyString("format");
    }

    @Override
    public void setTextWrap(boolean b) {
        this.propertySupport.setPropertyBool("wrapText", b);
        this.validateColumnValues();
    }

    @Override
    public boolean isTextWrap() {
        return this.propertySupport.getPropertyBool("wrapText");
    }

    @Override
    public boolean isSelectAllOnEdit() {
        return this.propertySupport.getPropertyBool("selectAllOnFocus");
    }

    @Override
    public void setSelectAllOnEdit(boolean b) {
        this.propertySupport.setPropertyBool("selectAllOnFocus", b);
    }

    @Override
    public boolean isValidateOnAnyKey() {
        return this.propertySupport.getPropertyBool("validateOnAnyKey");
    }

    @Override
    public void setValidateOnAnyKey(boolean b) {
        this.propertySupport.setPropertyBool("validateOnAnyKey", b);
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        this.validateColumnValues();
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    public boolean isEmpty() {
        ITable table = this.getTable();
        if (table != null) {
            int i = 0;
            int ni = table.getRowCount();
            while (i < ni) {
                String value = (String)this.getValue(table.getRow(i));
                if (value != null && value.length() > 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected String parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        String validValue = null;
        validValue = rawValue == null ? null : (rawValue instanceof String ? (String)rawValue : rawValue.toString());
        return validValue;
    }

    protected IFormField prepareEditInternalOld(ITableRow row) throws ProcessingException {
        AbstractStringField f = new AbstractStringField(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractStringColumn.this.propertySupport.getPropertiesMap());
            }
        };
        boolean multi = this.getTable() != null ? this.getTable().isMultilineText() : this.isTextWrap();
        f.setMultilineText(multi);
        f.setWrapText(true);
        return f;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractStringField f = new AbstractStringField(){};
        this.mapEditorFieldProperties(f);
        return f;
    }

    protected void mapEditorFieldProperties(AbstractStringField f) {
        super.mapEditorFieldProperties(f);
        f.setInputMasked(this.isInputMasked());
        f.setFormat(this.getDisplayFormat());
        f.setWrapText(this.isTextWrap());
        f.setSelectAllOnFocus(this.isSelectAllOnEdit());
        f.setValidateOnAnyKey(this.isValidateOnAnyKey());
        f.setMaxLength(this.getMaxLength());
        boolean multi = this.getTable() != null ? this.getTable().isMultilineText() : this.isTextWrap();
        f.setMultilineText(multi);
        f.setWrapText(true);
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        String format = this.getDisplayFormat();
        super.decorateCellInternal(cell, row);
        if (format != null && cell.getValue() != null) {
            if ("a".equals(format)) {
                cell.setText(((String)cell.getValue()).toLowerCase());
            } else if ("A".equals(format)) {
                cell.setText(((String)cell.getValue()).toUpperCase());
            }
        } else {
            cell.setText((String)cell.getValue());
        }
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        String s1 = (String)this.getValue(r1);
        String s2 = (String)this.getValue(r2);
        return StringUtility.compareIgnoreCase((String)s1, (String)s2);
    }

    protected IStringColumnExtension<? extends AbstractStringColumn> createLocalExtension() {
        return new LocalStringColumnExtension<AbstractStringColumn>(this);
    }

    protected static class LocalStringColumnExtension<OWNER extends AbstractStringColumn>
    extends AbstractColumn.LocalColumnExtension<String, OWNER>
    implements IStringColumnExtension<OWNER> {
        public LocalStringColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

