/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.Cell;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.IGridMatrix;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.MatrixCursor;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.MatrixIndex;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;

public class HorizontalGridMatrix
implements IGridMatrix {
    private final int m_columnCount;
    private int m_rowCount;
    private MatrixCursor m_cursor;
    private final Map<MatrixIndex, Cell> m_assignedCells = new HashMap<MatrixIndex, Cell>();

    public HorizontalGridMatrix(int columnCount) {
        this.m_columnCount = columnCount;
        this.m_cursor = new MatrixCursor(0, 0, columnCount, Integer.MAX_VALUE, MatrixCursor.Orientation.Horizontal);
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public int getRowCount() {
        return this.m_rowCount;
    }

    @Override
    public boolean computeGridData(List<IFormField> fields) {
        for (IFormField f : fields) {
            GridData hints = GridDataBuilder.createFromHints(f, this.m_columnCount);
            GridData gridData = new GridData(hints);
            gridData.w = Math.min(hints.w, this.m_columnCount);
            this.add(f, hints, gridData);
            f.setGridDataInternal(gridData);
        }
        return true;
    }

    private void add(IFormField field, GridData hints, GridData data) {
        this.nextFree(data.w, data.h);
        MatrixIndex currentIndex = this.m_cursor.currentIndex();
        if (data.w <= this.m_columnCount - currentIndex.x) {
            data.x = currentIndex.x;
            data.y = currentIndex.y;
            int xx = currentIndex.x;
            while (xx < currentIndex.x + data.w) {
                int yy = currentIndex.y;
                while (yy < currentIndex.y + data.h) {
                    this.m_assignedCells.put(new MatrixIndex(xx, yy), new Cell(field, data));
                    ++yy;
                }
                ++xx;
            }
            this.m_rowCount = currentIndex.y + data.h;
        } else {
            this.m_assignedCells.put(this.m_cursor.currentIndex(), new Cell());
            this.add(field, hints, data);
        }
    }

    private void nextFree(int w, int h) {
        this.m_cursor.increment();
        MatrixIndex currentIndex = this.m_cursor.currentIndex();
        if (!this.isAllCellFree(currentIndex.x, currentIndex.y, w, h)) {
            this.m_assignedCells.put(currentIndex, new Cell());
            this.nextFree(w, h);
        }
    }

    private boolean isAllCellFree(int x, int y, int w, int h) {
        if (x + w > this.getColumnCount()) {
            return false;
        }
        int xi = x;
        while (xi < x + w) {
            int yi = y;
            while (yi < y + h) {
                if (this.m_assignedCells.get(new MatrixIndex(xi, yi)) != null) {
                    return false;
                }
                ++yi;
            }
            ++xi;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("----Horizontal Grid Matrix [columnCount=" + this.getColumnCount() + ",rowCount=" + this.getRowCount() + "]--------------\n");
        MatrixCursor tempCursor = new MatrixCursor(0, 0, this.getColumnCount(), this.getRowCount(), MatrixCursor.Orientation.Horizontal);
        while (tempCursor.increment()) {
            Cell cell = this.m_assignedCells.get(tempCursor.currentIndex());
            builder.append("cell[").append(tempCursor.currentIndex().x).append(", ").append(tempCursor.currentIndex().y).append("] ");
            if (cell == null) {
                builder.append("NULL");
            } else if (cell.field == null) {
                builder.append("PlaceHolder");
            } else {
                builder.append(cell.field);
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

