/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.internal;

import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.shared.data.form.FormDataUtility;

public class FindFieldByFormDataIdVisitor
implements IFormFieldVisitor {
    private static final CompositeObject PERFECT_VALUE_FIELD_MATCH_KEY = new CompositeObject(new Object[]{0, 0});
    private static final Pattern FIELD_PATH_SPLIT_PATTERN = Pattern.compile("[/]");
    private final String[] m_fieldIdParts;
    private final SortedMap<CompositeObject, IFormField> m_prioMap;
    private IForm m_searchContextRootForm;

    public FindFieldByFormDataIdVisitor(String fieldId) {
        this(fieldId, null);
    }

    public FindFieldByFormDataIdVisitor(String fieldId, IForm searchContextRootForm) {
        this.m_searchContextRootForm = searchContextRootForm;
        this.m_fieldIdParts = FIELD_PATH_SPLIT_PATTERN.split(fieldId);
        this.m_prioMap = new TreeMap<CompositeObject, IFormField>();
    }

    @Override
    public boolean visitField(IFormField field, int level, int fieldIndex) {
        if (this.m_searchContextRootForm == null) {
            this.m_searchContextRootForm = field.getForm();
        }
        if (this.matchesAllParts(field)) {
            int fieldTypeRank = 0;
            if (this.m_searchContextRootForm != null) {
                IForm form = field.getForm();
                while (form != null && form != this.m_searchContextRootForm) {
                    fieldTypeRank += 10;
                    form = form.getOuterForm();
                }
            }
            if (!(field instanceof IValueField)) {
                fieldTypeRank = field instanceof ITableField ? ++fieldTypeRank : (!(field instanceof ICompositeField) ? (fieldTypeRank += 2) : (fieldTypeRank += 3));
            }
            int enclosingFieldPathRank = this.getEnclosingFieldPathRank(field);
            this.m_prioMap.put(new CompositeObject(new Object[]{fieldTypeRank, enclosingFieldPathRank}), field);
        }
        return !this.m_prioMap.containsKey(PERFECT_VALUE_FIELD_MATCH_KEY);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesAllParts(IFormField f) {
        int i = this.m_fieldIdParts.length - 1;
        if (!this.m_fieldIdParts[i].equals(FormDataUtility.getFieldDataId((String)f.getFieldId()))) {
            return false;
        }
        --i;
        f = f.getParentField();
        while (i >= 0 && f != null) {
            if (this.m_fieldIdParts[i].equals(FormDataUtility.getFieldDataId((String)f.getFieldId()))) {
                --i;
            }
            f = f.getParentField();
        }
        return i < 0;
    }

    private int getEnclosingFieldPathRank(IFormField f) {
        int rank = 0;
        int i = this.m_fieldIdParts.length - 2;
        List<ICompositeField> enclosingFieldList = f.getEnclosingFieldList();
        Collections.reverse(enclosingFieldList);
        for (ICompositeField p : enclosingFieldList) {
            if (i >= 0 && this.m_fieldIdParts[i].equals(FormDataUtility.getFieldDataId((String)p.getFieldId()))) {
                --i;
                continue;
            }
            ++rank;
        }
        return rank;
    }

    public IFormField getField() {
        return this.m_prioMap.size() > 0 ? (IFormField)this.m_prioMap.get(this.m_prioMap.firstKey()) : null;
    }
}

