/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.action.menu;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.extension.client.Activator;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuModifier;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuContributionExtension;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuExtensionManager;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuModificationExtension;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuRemoveExtension;

public final class MenuExtensionUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MenuExtensionUtility.class);

    private MenuExtensionUtility() {
    }

    public static <T> Class<T> getAnchorType(T anchor) {
        if (anchor == null) {
            return null;
        }
        if (anchor instanceof IPage) {
            return IPage.class;
        }
        if (anchor instanceof IFormField) {
            return IFormField.class;
        }
        if (anchor instanceof IMenu) {
            return IMenu.class;
        }
        if (anchor instanceof ITreeNode) {
            return ITreeNode.class;
        }
        if (anchor instanceof IDesktop) {
            return IDesktop.class;
        }
        return null;
    }

    public static <T> void adaptMenus(T anchor, Object container, OrderedCollection<IMenu> menus) {
        Class<T> anchorType = MenuExtensionUtility.getAnchorType(anchor);
        if (anchorType == null || anchor == null || container == null) {
            return;
        }
        MenuExtensionManager extensionManager = Activator.getDefault().getMenuExtensionManager();
        MenuExtensionUtility.contributeMenus(anchor, container, extensionManager.getMenuContributionExtensions(anchorType), menus);
        MenuExtensionUtility.removeMenus(anchor, container, extensionManager.getMenuRemoveExtensions(anchorType), menus);
        MenuExtensionUtility.modifyMenus(anchor, container, extensionManager.getMenuModificationExtensions(anchorType), menus);
    }

    static <T> void contributeMenus(T anchor, Object container, List<MenuContributionExtension> extensions, OrderedCollection<IMenu> menus) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        LinkedList<MenuContributionExtension> matchingExtensions = new LinkedList<MenuContributionExtension>();
        for (MenuContributionExtension e : extensions) {
            if (!e.accept(anchor, container, null)) continue;
            matchingExtensions.add(e);
        }
        if (matchingExtensions.isEmpty()) {
            return;
        }
        for (MenuContributionExtension e : matchingExtensions) {
            try {
                IMenu m = e.createContribution(anchor, container);
                m.setOrder(e.getOrder());
                menus.addOrdered((IOrdered)m);
            }
            catch (Throwable t) {
                LOG.error("Exception while creating an instance of contributed menu " + e, t);
            }
        }
    }

    static <T> void removeMenus(T anchor, Object container, List<MenuRemoveExtension> extensions, OrderedCollection<IMenu> menus) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        Iterator it = menus.iterator();
        block0: while (it.hasNext()) {
            IMenu next = (IMenu)it.next();
            for (MenuRemoveExtension removeExtension : extensions) {
                if (!removeExtension.accept(anchor, container, next)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    static <T> void modifyMenus(T anchor, Object container, List<MenuModificationExtension> extensions, OrderedCollection<IMenu> menus) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        for (MenuModificationExtension ext : extensions) {
            for (IMenu menu : menus) {
                try {
                    if (!ext.accept(anchor, container, menu)) continue;
                    IMenuModifier<IMenu> menuModifier = ext.createMenuModifier();
                    menuModifier.modify(anchor, container, menu);
                }
                catch (ProcessingException e) {
                    LOG.error("Exception while modifying menu", (Throwable)e);
                }
            }
        }
    }
}

