/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.StoppableThread;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticFactory;
import org.eclipse.scout.rt.server.admin.diagnostic.IDiagnostic;
import org.eclipse.scout.rt.server.scheduler.IScheduler;
import org.eclipse.scout.rt.server.scheduler.ISchedulerJob;
import org.eclipse.scout.rt.server.scheduler.Scheduler;
import org.eclipse.scout.rt.server.scheduler.TickSignal;
import org.eclipse.scout.rt.server.scheduler.Ticker;

public abstract class AbstractScheduler
implements IScheduler,
IDiagnostic {
    protected static final IScoutLogger LOG = ScoutLogManager.getLogger(Scheduler.class);
    private P_Dispatcher m_dispatcher;
    private final Object m_queueLock;
    private final HashSet<ISchedulerJob> m_availableJobs = new HashSet();
    private final HashSet<ISchedulerJob> m_runningJobs = new HashSet();
    private final Ticker m_ticker;
    private boolean m_active = true;

    public AbstractScheduler() throws ProcessingException {
        this(new Ticker(12));
    }

    public AbstractScheduler(Ticker ticker) throws ProcessingException {
        this.m_queueLock = new Object();
        this.m_ticker = ticker;
        DiagnosticFactory.addDiagnosticStatusProvider(this);
    }

    @Override
    public void setActive(boolean b) {
        this.m_active = b;
    }

    @Override
    public boolean isActive() {
        return this.m_active;
    }

    @Override
    public Ticker getTicker() {
        return this.m_ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.m_queueLock;
        synchronized (object) {
            if (this.m_dispatcher == null) {
                this.m_dispatcher = new P_Dispatcher();
                this.m_dispatcher.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.m_queueLock;
        synchronized (object) {
            if (this.m_dispatcher != null) {
                this.m_dispatcher.setStopSignal();
                this.m_dispatcher = null;
                for (ISchedulerJob job : this.m_runningJobs) {
                    try {
                        job.setInterrupted(true);
                    }
                    catch (Throwable t) {
                        LOG.error("" + job, t);
                    }
                }
            }
        }
    }

    private boolean matches(ISchedulerJob job, String groupId, String jobId) {
        return !(groupId != null && !groupId.equals(job.getGroupId()) || jobId != null && !jobId.equals(job.getJobId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJob(ISchedulerJob newJob) {
        if (newJob == null) {
            throw new IllegalArgumentException("job must not be null");
        }
        Object object = this.m_queueLock;
        synchronized (object) {
            newJob.setDisposed(false);
            String groupId = newJob.getGroupId();
            String jobId = newJob.getJobId();
            ArrayList<ISchedulerJob> oldJobs = new ArrayList<ISchedulerJob>();
            for (ISchedulerJob job : this.m_availableJobs) {
                if (!this.matches(job, groupId, jobId)) continue;
                job.setDisposed(true);
                oldJobs.add(job);
            }
            this.m_availableJobs.removeAll(oldJobs);
            this.m_availableJobs.add(newJob);
            boolean oldJobsRunning = false;
            for (ISchedulerJob job : this.m_runningJobs) {
                if (!this.matches(job, groupId, jobId)) continue;
                oldJobsRunning = true;
                break;
            }
            if (!oldJobsRunning) {
                TickSignal tick = this.m_ticker.getCurrentTick();
                this.visitJobWithoutLocking(newJob, tick);
            }
        }
    }

    @Override
    public void removeAllJobs() {
        this.removeJobs(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ISchedulerJob> removeJobs(String groupId, String jobId) {
        Object object = this.m_queueLock;
        synchronized (object) {
            ArrayList<ISchedulerJob> removedJobs = new ArrayList<ISchedulerJob>();
            for (ISchedulerJob job : this.m_availableJobs) {
                if (!this.matches(job, groupId, jobId)) continue;
                job.setDisposed(true);
                removedJobs.add(job);
            }
            this.m_availableJobs.removeAll(removedJobs);
            return removedJobs;
        }
    }

    @Override
    public void interruptAllJobs() {
        this.interruptJobs(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ISchedulerJob> interruptJobs(String groupId, String jobId) {
        Object object = this.m_queueLock;
        synchronized (object) {
            ArrayList<ISchedulerJob> intJobs = new ArrayList<ISchedulerJob>();
            for (ISchedulerJob job : this.m_availableJobs) {
                if (!this.matches(job, groupId, jobId) || !this.m_runningJobs.contains(job)) continue;
                job.setInterrupted(true);
                intJobs.add(job);
            }
            return intJobs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJobCount() {
        Object object = this.m_queueLock;
        synchronized (object) {
            return this.m_availableJobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRunningJobCount() {
        Object object = this.m_queueLock;
        synchronized (object) {
            return this.m_runningJobs.size();
        }
    }

    @Override
    public ISchedulerJob getJob(String jobId) {
        Collection<ISchedulerJob> list = this.getJobs(null, jobId);
        if (list.size() >= 1) {
            return list.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<ISchedulerJob> getAllJobs() {
        return this.getJobs(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ISchedulerJob> getJobs(String groupId, String jobId) {
        Object object = this.m_queueLock;
        synchronized (object) {
            ArrayList<ISchedulerJob> jobs = new ArrayList<ISchedulerJob>();
            for (ISchedulerJob job : this.m_availableJobs) {
                if (!this.matches(job, groupId, jobId)) continue;
                jobs.add(job);
            }
            return jobs;
        }
    }

    @Override
    public Collection<ISchedulerJob> getAllRunningJobs() {
        return this.getRunningJobs(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ISchedulerJob> getRunningJobs(String groupId, String jobId) {
        Object object = this.m_queueLock;
        synchronized (object) {
            ArrayList<ISchedulerJob> jobs = new ArrayList<ISchedulerJob>();
            for (ISchedulerJob job : this.m_runningJobs) {
                if (!this.matches(job, groupId, jobId)) continue;
                jobs.add(job);
            }
            return jobs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitAllJobs(TickSignal tick) {
        Object object = this.m_queueLock;
        synchronized (object) {
            this.visitAllJobsWithoutLocking(tick);
        }
    }

    protected void visitAllJobsWithoutLocking(TickSignal tick) {
        for (ISchedulerJob job : new ArrayList<ISchedulerJob>(this.m_availableJobs)) {
            this.visitJobWithoutLocking(job, tick);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitJob(ISchedulerJob job, TickSignal tick) {
        Object object = this.m_queueLock;
        synchronized (object) {
            this.visitJobWithoutLocking(job, tick);
        }
    }

    protected void visitJobWithoutLocking(ISchedulerJob job, TickSignal tick) {
        try {
            if (this.m_runningJobs.contains(job)) {
                if (LOG.isInfoEnabled() && job.acceptTick(tick)) {
                    LOG.info("job " + job + " is still running at " + tick);
                }
            } else if (job.isDisposed()) {
                this.m_availableJobs.remove(job);
            } else if (job.acceptTick(tick)) {
                this.m_runningJobs.add(job);
                if (LOG.isInfoEnabled()) {
                    LOG.info("job " + job + " triggered at " + tick);
                }
                P_JobRunner runner = new P_JobRunner(job, tick);
                Thread t = new Thread((Runnable)runner, "Scheduler.JobLauncher." + job.getGroupId() + "." + job.getJobId());
                t.setDaemon(true);
                t.start();
            }
        }
        catch (Throwable t) {
            LOG.error("" + job, t);
        }
    }

    @Override
    public void addDiagnosticItemToList(List<List<String>> result) {
        DiagnosticFactory.addDiagnosticItemToList(result, "Scheduler", "", this.isActive() ? "ACTIVE" : "INACTIVE");
        if (this.isActive()) {
            DiagnosticFactory.addDiagnosticItemToList(result, "Scheduler Jobs", "Total jobs: " + this.getJobCount() + ", Running: " + this.getRunningJobCount(), "INFO");
        }
    }

    @Override
    public String[] getPossibleActions() {
        return null;
    }

    @Override
    public void addSubmitButtonsHTML(List<List<String>> result) {
    }

    @Override
    public void call(String action, Object[] value) {
    }

    class P_Dispatcher
    extends StoppableThread {
        public P_Dispatcher() {
            this.setName("Scheduler.Dispatcher");
            this.setDaemon(true);
        }

        public void run() {
            if (LOG.isInfoEnabled()) {
                LOG.info("scheduler started");
            }
            TickSignal signal = AbstractScheduler.this.m_ticker.waitForNextTick();
            if (LOG.isDebugEnabled()) {
                LOG.debug("tick " + signal);
            }
            while (!this.isStopSignal()) {
                try {
                    if (AbstractScheduler.this.isActive()) {
                        AbstractScheduler.this.visitAllJobs(signal);
                        signal = AbstractScheduler.this.m_ticker.waitForNextTick();
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("tick " + signal);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ticking suspended");
                    }
                    try {
                        P_Dispatcher.sleep((long)1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    LOG.error("unexpected error: ", t);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("scheduler stopped");
            }
        }
    }

    class P_JobRunner
    implements Runnable {
        private ISchedulerJob m_job;
        private TickSignal m_signal;

        public P_JobRunner(ISchedulerJob job, TickSignal signal) {
            this.m_job = job;
            this.m_signal = signal;
        }

        public ISchedulerJob getJob() {
            return this.m_job;
        }

        public TickSignal getTickSignal() {
            return this.m_signal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                try {
                    try {
                        this.m_job.setInterrupted(false);
                        AbstractScheduler.this.handleJobExecution(this.m_job, this.m_signal);
                    }
                    catch (Throwable t) {
                        LOG.error("uncaught exception", t);
                        Object object = AbstractScheduler.this.m_queueLock;
                        synchronized (object) {
                            AbstractScheduler.this.m_runningJobs.remove(this.m_job);
                            if (this.m_job.isDisposed()) {
                                AbstractScheduler.this.m_availableJobs.remove(this.m_job);
                            }
                            break block17;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = AbstractScheduler.this.m_queueLock;
                    synchronized (object) {
                        AbstractScheduler.this.m_runningJobs.remove(this.m_job);
                        if (this.m_job.isDisposed()) {
                            AbstractScheduler.this.m_availableJobs.remove(this.m_job);
                        }
                    }
                    throw throwable;
                }
                Object object = AbstractScheduler.this.m_queueLock;
                synchronized (object) {
                    AbstractScheduler.this.m_runningJobs.remove(this.m_job);
                    if (this.m_job.isDisposed()) {
                        AbstractScheduler.this.m_availableJobs.remove(this.m_job);
                    }
                }
            }
        }
    }
}

